/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.mailbox.agronampscarrayqueue;

import io.vlingo.xoom.actors.Dispatcher;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.Message;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;

public class ManyToOneConcurrentArrayQueueMailbox
implements Mailbox {
    private final Dispatcher dispatcher;
    private final boolean notifyOnSend;
    private final ManyToOneConcurrentArrayQueue<Message> queue;
    private final int totalSendRetries;

    @Override
    public void close() {
        this.dispatcher.close();
        this.queue.clear();
    }

    @Override
    public boolean isClosed() {
        return this.dispatcher.isClosed();
    }

    @Override
    public boolean isDelivering() {
        throw new UnsupportedOperationException("ManyToOneConcurrentArrayQueueMailbox does not support this operation.");
    }

    @Override
    public int concurrencyCapacity() {
        return 1;
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("ManyToOneConcurrentArrayQueueMailbox does not support this operation.");
    }

    @Override
    public void resume(String name) {
        System.out.println("WARNING: ManyToOneConcurrentArrayQueueMailbox does not support resume(): " + name);
    }

    @Override
    public void send(Message message) {
        for (int tries = 0; tries < this.totalSendRetries; ++tries) {
            if (this.queue.offer((Object)message)) {
                if (this.notifyOnSend) {
                    this.dispatcher.execute(this);
                }
                return;
            }
            while (this.pendingMessages() >= this.queue.capacity()) {
            }
        }
        throw new IllegalStateException("Count not enqueue message due to busy mailbox.");
    }

    @Override
    public void suspendExceptFor(String name, Class<?> ... overrides) {
        if (!name.equals("#stopping")) {
            System.out.println("WARNING: ManyToOneConcurrentArrayQueueMailbox does not support suspendExceptFor(): " + name + " overrides: " + overrides);
        }
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    @Override
    public final Message receive() {
        return (Message)this.queue.poll();
    }

    @Override
    public int pendingMessages() {
        return this.queue.size();
    }

    protected ManyToOneConcurrentArrayQueueMailbox(Dispatcher dispatcher, int mailboxSize, int totalSendRetries, boolean notifyOnSend) {
        this.dispatcher = dispatcher;
        this.queue = new ManyToOneConcurrentArrayQueue(mailboxSize);
        this.totalSendRetries = totalSendRetries;
        this.notifyOnSend = notifyOnSend;
    }
}

