/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.mailbox.agronampscarrayqueue;

import io.vlingo.xoom.actors.Configuration;
import io.vlingo.xoom.actors.Dispatcher;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.MailboxProvider;
import io.vlingo.xoom.actors.Registrar;
import io.vlingo.xoom.actors.plugin.AbstractPlugin;
import io.vlingo.xoom.actors.plugin.Plugin;
import io.vlingo.xoom.actors.plugin.PluginConfiguration;
import io.vlingo.xoom.actors.plugin.PluginProperties;
import io.vlingo.xoom.actors.plugin.mailbox.agronampscarrayqueue.ManyToOneConcurrentArrayQueueDispatcher;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class ManyToOneConcurrentArrayQueuePlugin
extends AbstractPlugin
implements Plugin,
MailboxProvider {
    private final ManyToOneConcurrentArrayQueuePluginConfiguration configuration;
    private final Map<Integer, ManyToOneConcurrentArrayQueueDispatcher> dispatchers;

    public ManyToOneConcurrentArrayQueuePlugin() {
        this.configuration = new ManyToOneConcurrentArrayQueuePluginConfiguration();
        this.dispatchers = new ConcurrentHashMap<Integer, ManyToOneConcurrentArrayQueueDispatcher>(1);
    }

    @Override
    public void close() {
        this.dispatchers.values().stream().forEach(dispatcher -> dispatcher.close());
    }

    @Override
    public PluginConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public String name() {
        return this.configuration.name();
    }

    @Override
    public int pass() {
        return 1;
    }

    @Override
    public void start(Registrar registrar) {
        registrar.register(this.configuration.name(), this.configuration.isDefaultMailbox(), this);
    }

    @Override
    public Plugin with(PluginConfiguration overrideConfiguration) {
        if (overrideConfiguration == null) {
            return this;
        }
        return new ManyToOneConcurrentArrayQueuePlugin(overrideConfiguration);
    }

    private ManyToOneConcurrentArrayQueuePlugin(PluginConfiguration configuration) {
        this.configuration = (ManyToOneConcurrentArrayQueuePluginConfiguration)configuration;
        this.dispatchers = new ConcurrentHashMap<Integer, ManyToOneConcurrentArrayQueueDispatcher>(1);
    }

    @Override
    public Mailbox provideMailboxFor(int hashCode) {
        return this.provideMailboxFor(hashCode, null);
    }

    @Override
    public Mailbox provideMailboxFor(int hashCode, Dispatcher dispatcher) {
        ManyToOneConcurrentArrayQueueDispatcher maybeDispatcher;
        ManyToOneConcurrentArrayQueueDispatcher manyToOneConcurrentArrayQueueDispatcher = maybeDispatcher = dispatcher != null ? (ManyToOneConcurrentArrayQueueDispatcher)dispatcher : this.dispatchers.get(hashCode);
        if (maybeDispatcher == null) {
            ManyToOneConcurrentArrayQueueDispatcher newDispatcher = new ManyToOneConcurrentArrayQueueDispatcher(this.configuration.ringSize(), this.configuration.fixedBackoff(), this.configuration.notifyOnSend(), this.configuration.dispatcherThrottlingCount(), this.configuration.sendRetires());
            ManyToOneConcurrentArrayQueueDispatcher otherDispatcher = this.dispatchers.putIfAbsent(hashCode, newDispatcher);
            if (otherDispatcher != null) {
                otherDispatcher.start();
                return otherDispatcher.mailbox();
            }
            newDispatcher.start();
            return newDispatcher.mailbox();
        }
        return maybeDispatcher.mailbox();
    }

    @Override
    public void __internal_Only_Init(String name, Configuration configuration, Properties properties) {
        this.configuration.name = name;
    }

    public static class ManyToOneConcurrentArrayQueuePluginConfiguration
    implements PluginConfiguration {
        private boolean defaultMailbox;
        private int dispatcherThrottlingCount;
        private int fixedBackoff;
        private String name = "arrayQueueMailbox";
        private boolean notifyOnSend;
        private int ringSize;
        private int sendRetires;

        public static ManyToOneConcurrentArrayQueuePluginConfiguration define() {
            return new ManyToOneConcurrentArrayQueuePluginConfiguration();
        }

        public ManyToOneConcurrentArrayQueuePluginConfiguration defaultMailbox() {
            this.defaultMailbox = true;
            return this;
        }

        public boolean isDefaultMailbox() {
            return this.defaultMailbox;
        }

        public ManyToOneConcurrentArrayQueuePluginConfiguration dispatcherThrottlingCount(int dispatcherThrottlingCount) {
            this.dispatcherThrottlingCount = dispatcherThrottlingCount;
            return this;
        }

        public int dispatcherThrottlingCount() {
            return this.dispatcherThrottlingCount;
        }

        public ManyToOneConcurrentArrayQueuePluginConfiguration fixedBackoff(int fixedBackoff) {
            this.fixedBackoff = fixedBackoff;
            return this;
        }

        public int fixedBackoff() {
            return this.fixedBackoff;
        }

        public ManyToOneConcurrentArrayQueuePluginConfiguration notifyOnSend(boolean notifyOnSend) {
            this.notifyOnSend = notifyOnSend;
            return this;
        }

        public boolean notifyOnSend() {
            return this.notifyOnSend;
        }

        public ManyToOneConcurrentArrayQueuePluginConfiguration ringSize(int ringSize) {
            this.ringSize = ringSize;
            return this;
        }

        public int ringSize() {
            return this.ringSize;
        }

        public ManyToOneConcurrentArrayQueuePluginConfiguration sendRetires(int sendRetires) {
            this.sendRetires = sendRetires;
            return this;
        }

        public int sendRetires() {
            return this.sendRetires;
        }

        @Override
        public void build(Configuration configuration) {
            configuration.with(this.ringSize(65535).dispatcherThrottlingCount(1).fixedBackoff(2).notifyOnSend(false).sendRetires(10));
        }

        @Override
        public void buildWith(Configuration configuration, PluginProperties properties) {
            this.name = properties.name;
            this.defaultMailbox = properties.getBoolean("defaultMailbox", false);
            this.dispatcherThrottlingCount = properties.getInteger("dispatcherThrottlingCount", 1);
            this.fixedBackoff = properties.getInteger("fixedBackoff", 2);
            this.notifyOnSend = properties.getBoolean("notifyOnSend", false);
            this.ringSize = properties.getInteger("size", 65535);
            this.sendRetires = properties.getInteger("sendRetires", 10);
            configuration.with(this);
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

