/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.mailbox.concurrentqueue;

import io.vlingo.xoom.actors.Dispatcher;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.Message;
import io.vlingo.xoom.actors.ResumingMailbox;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class ConcurrentQueueMailbox
implements Mailbox,
Runnable {
    private AtomicBoolean delivering;
    private final Dispatcher dispatcher;
    private AtomicReference<SuspendedDeliveryOverrides> suspendedDeliveryOverrides;
    private final Queue<Message> queue;
    private final byte throttlingCount;

    @Override
    public void close() {
        this.queue.clear();
    }

    @Override
    public boolean isClosed() {
        return this.dispatcher.isClosed();
    }

    @Override
    public int concurrencyCapacity() {
        return this.dispatcher.concurrencyCapacity();
    }

    @Override
    public void resume(String name) {
        if (this.suspendedDeliveryOverrides.get().pop(name)) {
            this.dispatcher.execute(this);
        }
    }

    @Override
    public void send(Message message) {
        if (this.isSuspended()) {
            if (this.suspendedDeliveryOverrides.get().matchesTop(message.protocol())) {
                this.dispatcher.execute(new ResumingMailbox(message));
                if (!this.queue.isEmpty()) {
                    this.dispatcher.execute(this);
                }
                return;
            }
            this.queue.add(message);
        } else {
            this.queue.add(message);
            if (!this.isDelivering()) {
                this.dispatcher.execute(this);
            }
        }
    }

    @Override
    public void suspendExceptFor(String name, Class<?> ... overrides) {
        this.suspendedDeliveryOverrides.get().push(new Overrides(name, overrides));
    }

    @Override
    public boolean isSuspended() {
        return !this.suspendedDeliveryOverrides.get().isEmpty();
    }

    @Override
    public boolean isSuspendedFor(String name) {
        return !this.suspendedDeliveryOverrides.get().find(name).isEmpty();
    }

    @Override
    public Message receive() {
        return this.queue.poll();
    }

    @Override
    public boolean isDelivering() {
        return this.delivering.get();
    }

    @Override
    public void run() {
        if (this.delivering.compareAndSet(false, true)) {
            Message message;
            int total = this.throttlingCount;
            for (int count = 0; count < total && !this.isSuspended() && (message = this.receive()) != null; ++count) {
                message.deliver();
            }
            this.delivering.set(false);
            if (!this.queue.isEmpty()) {
                this.dispatcher.execute(this);
            }
        }
    }

    @Override
    public int pendingMessages() {
        return this.queue.size();
    }

    protected ConcurrentQueueMailbox(Dispatcher dispatcher, int throttlingCount) {
        this.dispatcher = dispatcher;
        this.delivering = new AtomicBoolean(false);
        this.suspendedDeliveryOverrides = new AtomicReference<SuspendedDeliveryOverrides>(new SuspendedDeliveryOverrides());
        this.queue = new ConcurrentLinkedQueue<Message>();
        this.throttlingCount = (byte)throttlingCount;
    }

    private static class Overrides {
        final String name;
        boolean obsolete;
        final Class<?>[] types;

        Overrides(String name, Class<?>[] types) {
            this.name = name;
            this.types = types;
            this.obsolete = false;
        }
    }

    private static class SuspendedDeliveryOverrides {
        private final AtomicBoolean accessible = new AtomicBoolean(false);
        private final List<Overrides> overrides = new ArrayList<Overrides>(0);

        SuspendedDeliveryOverrides() {
        }

        boolean isEmpty() {
            return this.overrides.isEmpty();
        }

        boolean matchesTop(Class<?> messageType) {
            Overrides overrides = this.peek();
            if (overrides != null) {
                for (Class<?> type : overrides.types) {
                    if (messageType != type) continue;
                    return true;
                }
            }
            return false;
        }

        Overrides peek() {
            int retries = 0;
            do {
                if (!this.accessible.compareAndSet(false, true)) continue;
                Overrides temp = null;
                if (!this.isEmpty()) {
                    temp = this.overrides.get(0);
                }
                this.accessible.set(false);
                return temp;
            } while (++retries <= 100000000);
            new Exception().printStackTrace();
            return null;
        }

        List<Overrides> find(String name) {
            int retries = 0;
            do {
                if (!this.accessible.compareAndSet(false, true)) continue;
                List overridesNamed = this.overrides.stream().filter(o -> o.name.equals(name)).collect(Collectors.toCollection(ArrayList::new));
                this.accessible.set(false);
                return overridesNamed;
            } while (++retries <= 100000000);
            new Exception().printStackTrace();
            return Collections.emptyList();
        }

        boolean pop(String name) {
            boolean popped;
            block5: {
                popped = false;
                int retries = 0;
                do {
                    if (!this.accessible.compareAndSet(false, true)) continue;
                    int elements = this.overrides.size();
                    for (int index = 0; index < elements; ++index) {
                        if (!name.equals(this.overrides.get((int)index).name)) continue;
                        if (index == 0) {
                            this.overrides.remove(index);
                            popped = true;
                            --elements;
                            while (index < elements && this.overrides.get((int)index).obsolete) {
                                this.overrides.remove(index);
                                --elements;
                            }
                        } else {
                            this.overrides.get((int)index).obsolete = true;
                        }
                        this.accessible.set(false);
                        break block5;
                    }
                    break block5;
                } while (++retries <= 100000000);
                new Exception().printStackTrace();
                return false;
            }
            return popped;
        }

        void push(Overrides overrides) {
            block1: {
                int retries = 0;
                do {
                    if (this.accessible.compareAndSet(false, true)) break block1;
                } while (++retries <= 100000000);
                new Exception().printStackTrace();
                return;
            }
            this.overrides.add(overrides);
            this.accessible.set(false);
        }
    }
}

