/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.mailbox.concurrentqueue;

import io.vlingo.xoom.actors.Dispatcher;
import io.vlingo.xoom.actors.Mailbox;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExecutorDispatcher
implements Dispatcher {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ExecutorService executor;
    private final int numberOfThreads;

    protected ExecutorDispatcher(int availableThreads, int numberOfDispatchers, float numberOfDispatchersFactor) {
        this.numberOfThreads = numberOfDispatchers > 0 ? numberOfDispatchers : (int)((float)availableThreads * numberOfDispatchersFactor);
        this.executor = new ThreadPoolExecutor(this.numberOfThreads, this.numberOfThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new RejectionHandler());
    }

    @Override
    public int concurrencyCapacity() {
        return this.numberOfThreads;
    }

    @Override
    public void close() {
        this.closed.set(true);
        this.executor.shutdown();
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void execute(Mailbox mailbox) {
        if (!this.closed.get()) {
            this.executor.execute(mailbox);
        }
    }

    @Override
    public boolean requiresExecutionNotification() {
        return false;
    }

    private class RejectionHandler
    implements RejectedExecutionHandler {
        private RejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor executor) {
            if (!executor.isShutdown() && !executor.isTerminated()) {
                throw new IllegalStateException("Message cannot be sent due to current system resource limitations.");
            }
        }
    }
}

