/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.mailbox.sharedringbuffer;

import io.vlingo.xoom.actors.Backoff;
import io.vlingo.xoom.actors.Dispatcher;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.Message;
import io.vlingo.xoom.actors.plugin.mailbox.sharedringbuffer.SharedRingBufferMailbox;
import java.util.concurrent.atomic.AtomicBoolean;

public class RingBufferDispatcher
extends Thread
implements Dispatcher {
    private final Backoff backoff;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Mailbox mailbox;
    private final boolean requiresExecutionNotification;
    private final int throttlingCount;

    @Override
    public void close() {
        this.closed.set(true);
        this.mailbox.close();
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public int concurrencyCapacity() {
        return 1;
    }

    @Override
    public void execute(Mailbox mailbox) {
        this.interrupt();
    }

    @Override
    public boolean requiresExecutionNotification() {
        return this.requiresExecutionNotification;
    }

    @Override
    public void run() {
        while (!this.closed.get()) {
            if (this.deliver()) continue;
            this.backoff.now();
        }
    }

    @Override
    public synchronized void start() {
        super.start();
    }

    RingBufferDispatcher(int mailboxSize, long fixedBackoff, boolean notifyOnSend, int throttlingCount) {
        this.backoff = fixedBackoff == 0L ? new Backoff() : new Backoff(fixedBackoff);
        this.requiresExecutionNotification = fixedBackoff == 0L;
        this.mailbox = new SharedRingBufferMailbox(this, mailboxSize, notifyOnSend);
        this.throttlingCount = throttlingCount;
    }

    protected Mailbox mailbox() {
        return this.mailbox;
    }

    private boolean deliver() {
        for (int idx = 0; idx < this.throttlingCount; ++idx) {
            Message message = this.mailbox.receive();
            if (message == null) {
                return idx > 0;
            }
            message.deliver();
        }
        return true;
    }
}

