/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.mailbox.sharedringbuffer;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Dispatcher;
import io.vlingo.xoom.actors.LocalMessage;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.Message;
import io.vlingo.xoom.actors.Returns;
import io.vlingo.xoom.common.SerializableConsumer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public class SharedRingBufferMailbox
implements Mailbox {
    private final AtomicBoolean closed;
    private final Dispatcher dispatcher;
    private final int mailboxSize;
    private final Message[] messages;
    private final boolean notifyOnSend;
    private final AtomicLong sendIndex;
    private final AtomicLong readyIndex;
    private final AtomicLong receiveIndex;

    @Override
    public void close() {
        if (!this.closed.get()) {
            this.closed.set(true);
            this.dispatcher.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public boolean isDelivering() {
        throw new UnsupportedOperationException("SharedRingBufferMailbox does not support this operation.");
    }

    @Override
    public boolean isPreallocated() {
        return true;
    }

    @Override
    public int concurrencyCapacity() {
        return 1;
    }

    @Override
    public void resume(String name) {
        throw new UnsupportedOperationException("SharedRingBufferMailbox does not support this operation.");
    }

    @Override
    public void send(Message message) {
        throw new UnsupportedOperationException("Use preallocated mailbox send(Actor, ...).");
    }

    @Override
    public void suspendExceptFor(String name, Class<?> ... overrides) {
        throw new UnsupportedOperationException("SharedRingBufferMailbox does not support this operation.");
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    @Override
    public void send(Actor actor, Class<?> protocol, SerializableConsumer<?> consumer, Returns<?> returns, String representation) {
        long messageIndex = this.sendIndex.incrementAndGet();
        int ringSendIndex = (int)(messageIndex % (long)this.mailboxSize);
        int retries = 0;
        while (ringSendIndex == (int)(this.receiveIndex.get() % (long)this.mailboxSize)) {
            if (++retries < this.mailboxSize) continue;
            if (this.closed.get()) {
                return;
            }
            retries = 0;
        }
        this.messages[ringSendIndex].set(actor, protocol, consumer, returns, representation);
        while (!this.readyIndex.compareAndSet(messageIndex - 1L, messageIndex)) {
        }
        if (this.notifyOnSend) {
            this.dispatcher.execute(this);
        }
    }

    @Override
    public Message receive() {
        long messageIndex = this.receiveIndex.get();
        if (messageIndex < this.readyIndex.get()) {
            int index = (int)(this.receiveIndex.incrementAndGet() % (long)this.mailboxSize);
            return this.messages[index];
        }
        return null;
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("SharedRingBufferMailbox does not support this operation.");
    }

    @Override
    public int pendingMessages() {
        throw new UnsupportedOperationException("SharedRingBufferMailbox does not support this operation");
    }

    protected SharedRingBufferMailbox(Dispatcher dispatcher, int mailboxSize, boolean notifyOnSend) {
        this.dispatcher = dispatcher;
        this.mailboxSize = mailboxSize;
        this.closed = new AtomicBoolean(false);
        this.messages = new Message[mailboxSize];
        this.readyIndex = new AtomicLong(-1L);
        this.receiveIndex = new AtomicLong(-1L);
        this.sendIndex = new AtomicLong(-1L);
        this.notifyOnSend = notifyOnSend;
        this.initPreallocated();
    }

    private void initPreallocated() {
        for (int idx = 0; idx < this.mailboxSize; ++idx) {
            this.messages[idx] = new LocalMessage(this);
        }
    }
}

