/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.mailbox.testkit;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Mailbox;
import io.vlingo.xoom.actors.Message;
import io.vlingo.xoom.actors.testkit.TestWorld;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;

public class TestMailbox
implements Mailbox {
    public static final String Name = "testerMailbox";
    private final List<String> lifecycleMessages = Arrays.asList("start", "afterStop", "beforeRestart", "afterRestart");
    private boolean closed;
    private final Queue<Message> queue;
    private AtomicReference<Stack<List<Class<?>>>> suspendedOverrides;
    private final TestWorld world = TestWorld.Instance.get();

    public TestMailbox() {
        this.queue = new ConcurrentLinkedQueue<Message>();
        this.suspendedOverrides = new AtomicReference(new Stack());
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException("TestMailbox does not support this operation.");
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isDelivering() {
        throw new UnsupportedOperationException("TestMailbox does not support this operation.");
    }

    @Override
    public int concurrencyCapacity() {
        return 1;
    }

    @Override
    public void resume(String name) {
        if (!this.suspendedOverrides.get().empty()) {
            this.suspendedOverrides.get().pop();
        }
        this.resumeAll();
    }

    @Override
    public void send(Message message) {
        try {
            if (!message.actor().isStopped() && !this.isLifecycleMessage(message)) {
                this.world.track(message);
            }
            if (this.isSuspended()) {
                this.queue.add(message);
                return;
            }
            this.resumeAll();
            message.actor().viewTestStateInitialization(null);
            message.deliver();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }

    @Override
    public void suspendExceptFor(String name, Class<?> ... overrides) {
        this.suspendedOverrides.get().push(Arrays.asList(overrides));
    }

    @Override
    public boolean isSuspended() {
        return !this.suspendedOverrides.get().empty();
    }

    @Override
    public boolean isSuspendedFor(String name) {
        return this.isSuspended();
    }

    @Override
    public Message receive() {
        throw new UnsupportedOperationException("TestMailbox does not support this operation.");
    }

    @Override
    public int pendingMessages() {
        throw new UnsupportedOperationException("TestMailbox does not support this operation");
    }

    private void resumeAll() {
        while (!this.queue.isEmpty()) {
            Actor actor;
            Message queued = this.queue.poll();
            if (queued == null || (actor = queued.actor()) == null) continue;
            actor.viewTestStateInitialization(null);
            queued.deliver();
        }
    }

    private boolean isLifecycleMessage(Message message) {
        String representation = message.representation();
        int openParenIndex = representation.indexOf("(");
        return this.lifecycleMessages.contains(representation.substring(0, openParenIndex));
    }
}

