/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.supervision;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Configuration;
import io.vlingo.xoom.actors.Registrar;
import io.vlingo.xoom.actors.plugin.AbstractPlugin;
import io.vlingo.xoom.actors.plugin.Plugin;
import io.vlingo.xoom.actors.plugin.PluginConfiguration;
import io.vlingo.xoom.actors.plugin.PluginProperties;
import io.vlingo.xoom.actors.plugin.supervision.ConfiguredSupervisor;
import io.vlingo.xoom.actors.plugin.supervision.DefinitionValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DefaultSupervisorOverridePlugin
extends AbstractPlugin
implements Plugin {
    private final DefaultSupervisorOverridePluginConfiguration configuration;

    public DefaultSupervisorOverridePlugin() {
        this.configuration = new DefaultSupervisorOverridePluginConfiguration();
    }

    @Override
    public void close() {
    }

    @Override
    public PluginConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public String name() {
        return "override_supervisor";
    }

    @Override
    public int pass() {
        return 2;
    }

    @Override
    public void start(Registrar registrar) {
        for (ConfiguredSupervisor supervisor : this.configuration.supervisors) {
            registrar.registerDefaultSupervisor(supervisor.stageName, supervisor.supervisorName, supervisor.supervisorClass);
        }
    }

    @Override
    public Plugin with(PluginConfiguration overrideConfiguration) {
        if (overrideConfiguration == null) {
            return this;
        }
        return new DefaultSupervisorOverridePlugin(overrideConfiguration);
    }

    @Override
    public void __internal_Only_Init(String name, Configuration configuration, Properties properties) {
    }

    private DefaultSupervisorOverridePlugin(PluginConfiguration configuration) {
        this.configuration = (DefaultSupervisorOverridePluginConfiguration)configuration;
    }

    public static class DefaultSupervisorOverridePluginConfiguration
    implements PluginConfiguration {
        private final List<ConfiguredSupervisor> supervisors = new ArrayList<ConfiguredSupervisor>();

        public static DefaultSupervisorOverridePluginConfiguration define() {
            return new DefaultSupervisorOverridePluginConfiguration();
        }

        public DefaultSupervisorOverridePluginConfiguration supervisor(String stageName, String supervisorName, Class<? extends Actor> supervisorClass) {
            this.supervisors.add(new ConfiguredSupervisor(stageName, supervisorName, supervisorClass));
            return this;
        }

        public int count() {
            return this.supervisors.size();
        }

        public String name(int index) {
            return this.supervisors.get((int)index).supervisorName;
        }

        public String stageName(int index) {
            return this.supervisors.get((int)index).stageName;
        }

        public Class<? extends Actor> supervisorClass(int index) {
            return this.supervisors.get((int)index).supervisorClass;
        }

        @Override
        public void build(Configuration configuration) {
            configuration.with(this.supervisor("default", "overrideSupervisor", ConfiguredSupervisor.supervisorFrom("io.vlingo.xoom.actors.plugin.supervision.DefaultSupervisorOverride")));
        }

        @Override
        public void buildWith(Configuration configuration, PluginProperties properties) {
            for (DefinitionValues values : DefinitionValues.allDefinitionValues(properties)) {
                ConfiguredSupervisor supervisor = new ConfiguredSupervisor(values.stageName, values.name, values.supervisor);
                this.supervisors.add(supervisor);
            }
            configuration.with(this);
        }

        @Override
        public String name() {
            return this.name(0);
        }

        private DefaultSupervisorOverridePluginConfiguration() {
        }
    }
}

