/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.plugin.supervision;

import io.vlingo.xoom.actors.plugin.PluginProperties;
import java.util.ArrayList;
import java.util.List;

class DefinitionValues {
    private static final String STAGE = "stage=";
    private static final String NAME = "name=";
    private static final String PROTOCOL = "protocol=";
    private static final String SUPERVISOR = "supervisor=";
    final String name;
    final String protocol;
    final String stageName;
    final String supervisor;

    static List<DefinitionValues> allDefinitionValues(PluginProperties properties) {
        ArrayList<DefinitionValues> settings = new ArrayList<DefinitionValues>();
        String types = properties.getString("types", "");
        int nextDefinition = 0;
        boolean hasNext = true;
        while (hasNext) {
            int open = types.indexOf("[", nextDefinition);
            int close = types.indexOf("]", open + 1);
            if (open >= 0 && close >= 0) {
                String definition = types.substring(open + 1, close);
                settings.add(new DefinitionValues(definition));
                nextDefinition = close + 1;
                continue;
            }
            hasNext = false;
        }
        return settings;
    }

    DefinitionValues(String definition) {
        this.stageName = this.stageFrom(definition);
        this.name = this.nameFrom(definition);
        this.protocol = this.protocolFrom(definition);
        this.supervisor = this.supervisorFrom(definition);
    }

    private String nameFrom(String definition) {
        return this.partFor(definition, NAME);
    }

    private String protocolFrom(String definition) {
        return this.partFor(definition, PROTOCOL);
    }

    private String stageFrom(String definition) {
        return this.partFor(definition, STAGE);
    }

    private String supervisorFrom(String definition) {
        return this.partFor(definition, SUPERVISOR);
    }

    private String partFor(String definition, String partName) {
        int start = definition.indexOf(partName);
        if (start == -1) {
            return "";
        }
        int startName = start + partName.length();
        int end = definition.indexOf(" ", startName);
        int actualEnd = end >= 0 ? end : definition.length();
        String part = definition.substring(startName, actualEnd);
        return part;
    }
}

