/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.pubsub;

import io.vlingo.xoom.actors.pubsub.AffectedSubscriptions;
import io.vlingo.xoom.actors.pubsub.Message;
import io.vlingo.xoom.actors.pubsub.Publisher;
import io.vlingo.xoom.actors.pubsub.Subscriber;
import io.vlingo.xoom.actors.pubsub.Subscriptions;
import io.vlingo.xoom.actors.pubsub.Topic;

public class DefaultPublisher
implements Publisher {
    private final Subscriptions subscriptions = new Subscriptions();

    @Override
    public void publish(Topic topic, Message message) {
        this.subscriptions.forTopic(topic).forEach(subscriber -> subscriber.receive(message));
    }

    @Override
    public boolean subscribe(Topic topic, Subscriber<?> subscriber) {
        AffectedSubscriptions affectedSubscriptions = this.subscriptions.create(topic, subscriber);
        return affectedSubscriptions.hasAny();
    }

    @Override
    public boolean unsubscribe(Topic topic, Subscriber<?> subscriber) {
        AffectedSubscriptions affectedSubscriptions = this.subscriptions.cancel(topic, subscriber);
        return affectedSubscriptions.hasAny();
    }

    @Override
    public void unsubscribeAllTopics(Subscriber<?> subscriber) {
        this.subscriptions.cancelAll(subscriber);
    }
}

