/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.pubsub;

import io.vlingo.xoom.actors.pubsub.AffectedSubscriptions;
import io.vlingo.xoom.actors.pubsub.Subscriber;
import io.vlingo.xoom.actors.pubsub.Topic;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Subscriptions {
    private Map<Topic, Set<Subscriber<?>>> index = new HashMap();

    public AffectedSubscriptions create(Topic topic, Subscriber<?> subscriber) {
        if (!this.index.containsKey(topic)) {
            this.index.put(topic, new HashSet());
        }
        return this.performOperation(topic, subscriber, this.defaultCondition(), this.insertOperation());
    }

    public AffectedSubscriptions cancel(Topic topic, Subscriber<?> subscriber) {
        return this.performOperation(topic, subscriber, this.defaultCondition(), this.removalOperation());
    }

    public AffectedSubscriptions cancelAll(Subscriber<?> subscriber) {
        return this.performOperation(null, subscriber, this.noCondition(), this.removalOperation());
    }

    public Set<Subscriber<?>> forTopic(Topic topic) {
        HashSet subscribers = new HashSet();
        this.index.entrySet().forEach(subscription -> {
            Topic subscribedTopic = (Topic)subscription.getKey();
            if (subscribedTopic.equals(topic) || subscribedTopic.isSubTopic(topic)) {
                subscribers.addAll((Collection)subscription.getValue());
            }
        });
        return subscribers;
    }

    private Operation insertOperation() {
        return (existingValues, givenValue) -> existingValues.add(givenValue);
    }

    private Operation removalOperation() {
        return (existingValues, givenValue) -> existingValues.remove(givenValue);
    }

    private Condition defaultCondition() {
        return (subscription, topic, subscriber) -> ((Topic)subscription.getKey()).equals(topic);
    }

    private Condition noCondition() {
        return (subscription, topic, subscriber) -> true;
    }

    private AffectedSubscriptions performOperation(Topic topic, Subscriber<?> subscriber, Condition condition, Operation operation) {
        AffectedSubscriptions affectedSubscriptions = new AffectedSubscriptions();
        this.index.entrySet().forEach(subscription -> {
            if (condition.should((Map.Entry<Topic, Set<Subscriber<?>>>)subscription, topic, subscriber) && operation.perform((Set)subscription.getValue(), subscriber)) {
                affectedSubscriptions.add(topic, subscriber);
            }
        });
        return affectedSubscriptions;
    }

    @FunctionalInterface
    private static interface Condition {
        public boolean should(Map.Entry<Topic, Set<Subscriber<?>>> var1, Topic var2, Subscriber<?> var3);
    }

    @FunctionalInterface
    private static interface Operation {
        public boolean perform(Set<Subscriber<?>> var1, Subscriber<?> var2);
    }
}

