/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.testkit;

import io.vlingo.xoom.actors.testkit.AccessSafely;
import java.util.concurrent.atomic.AtomicReference;

public class TestContext {
    private AccessSafely access;
    private final AtomicReference<Object> reference;

    public TestContext() {
        this.access = AccessSafely.afterCompleting(0);
        this.reference = new AtomicReference();
        this.setUpWriteRead();
    }

    public TestContext(int times) {
        this.access = AccessSafely.afterCompleting(times);
        this.reference = new AtomicReference();
        this.setUpWriteRead();
    }

    public AccessSafely access() {
        return this.access;
    }

    public <T> T mustComplete() {
        return this.access.readFrom("reference");
    }

    public <T> TestContext initialReferenceValueOf(T value) {
        this.reference.set(value);
        return this;
    }

    public <T> T referenceValue() {
        return (T)this.reference.get();
    }

    public <T> TestContext referenceValueTo(T value) {
        this.access.writeUsing("reference", value);
        return this;
    }

    public TestContext resetAfterCompletingTo(int times) {
        this.access = this.access.resetAfterCompletingTo(times);
        return this;
    }

    private void setUpWriteRead() {
        this.access.writingWith("reference", value -> this.reference.set(value)).readingWith("reference", () -> this.reference.get());
    }
}

