/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.xoom.actors.testkit;

import io.vlingo.xoom.actors.Actor;
import io.vlingo.xoom.actors.Address;
import io.vlingo.xoom.actors.Configuration;
import io.vlingo.xoom.actors.Definition;
import io.vlingo.xoom.actors.Logger;
import io.vlingo.xoom.actors.LoggerProvider;
import io.vlingo.xoom.actors.MailboxProvider;
import io.vlingo.xoom.actors.Message;
import io.vlingo.xoom.actors.Protocols;
import io.vlingo.xoom.actors.Stage;
import io.vlingo.xoom.actors.World;
import io.vlingo.xoom.actors.plugin.mailbox.testkit.TestMailboxPlugin;
import io.vlingo.xoom.actors.testkit.TestActor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class TestWorld
implements AutoCloseable {
    public static ThreadLocal<TestWorld> Instance = new ThreadLocal();
    private final Map<Long, List<Message>> actorMessages;
    private final MailboxProvider mailboxProvider;
    private final World world;

    public static TestWorld start(String name) {
        World world = World.start(name);
        return new TestWorld(world, name);
    }

    public static synchronized TestWorld start(String name, Properties properties) {
        World world = World.start(name, properties);
        return new TestWorld(world, name);
    }

    public static TestWorld start(String name, Configuration configuration) {
        World world = World.start(name, configuration);
        return new TestWorld(world, name);
    }

    public static TestWorld start(String name, LoggerProvider loggerProvider) {
        return new TestWorld(World.start(name), name);
    }

    public static TestWorld startWith(World world) {
        return new TestWorld(world, world.name());
    }

    public static synchronized TestWorld startWithDefaults(String name) {
        return new TestWorld(World.start(name, Configuration.define()), name);
    }

    public <T> TestActor<T> actorFor(Class<T> protocol, Class<? extends Actor> type, Object ... parameters) {
        if (this.isTerminated()) {
            throw new IllegalStateException("XOOM: Stopped.");
        }
        return this.world.stage().testActorFor(protocol, type, parameters);
    }

    public <T> TestActor<T> actorFor(Class<T> protocol, Definition definition) {
        if (this.world.isTerminated()) {
            throw new IllegalStateException("XOOM: TestWorld has stopped.");
        }
        return this.world.stage().testActorFor(protocol, definition);
    }

    public Protocols actorFor(Class<?>[] protocols, Definition definition) {
        if (this.world.isTerminated()) {
            throw new IllegalStateException("XOOM: TestWorld has stopped.");
        }
        return this.world.stage().testActorFor(protocols, definition);
    }

    public List<Message> allMessagesFor(Address address) {
        ArrayList all = this.actorMessages.get(address.id());
        return all == null ? new ArrayList() : all;
    }

    public void clearTrackedMessages() {
        this.actorMessages.clear();
    }

    @Override
    public void close() throws Exception {
        if (!this.isTerminated()) {
            this.terminate();
        }
    }

    public Logger defaultLogger() {
        return this.world.defaultLogger();
    }

    public Logger logger(String name) {
        return this.world.logger(name);
    }

    public Stage stage() {
        return this.world.stage();
    }

    public Stage stageNamed(String name) {
        return this.world.stageNamed(name);
    }

    public boolean isTerminated() {
        return this.world.isTerminated();
    }

    public void terminate() {
        this.world.terminate();
        this.actorMessages.clear();
        Instance.set(null);
    }

    public void track(Message message) {
        long id = message.actor().address().id();
        List messages = this.actorMessages.computeIfAbsent(id, k -> new ArrayList());
        messages.add(message);
    }

    public World world() {
        return this.world;
    }

    protected MailboxProvider mailboxProvider() {
        return this.mailboxProvider;
    }

    private TestWorld(World world, String name) {
        Instance.set(this);
        this.world = world;
        this.actorMessages = new HashMap<Long, List<Message>>();
        this.mailboxProvider = new TestMailboxPlugin(this.world);
    }
}

