/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster;

import io.vlingo.cluster.model.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class ClusterProperties {
    private static final Random random = new Random();
    private static AtomicInteger PORT_TO_USE = new AtomicInteger(10000 + random.nextInt(50000));

    public static Properties allNodes() {
        return ClusterProperties.allNodes(PORT_TO_USE);
    }

    public static Properties allNodes(AtomicInteger portSeed) {
        java.util.Properties properties = new java.util.Properties();
        properties = ClusterProperties.common(ClusterProperties.allOf(properties, portSeed), 3);
        Properties clusterProperties = Properties.openForTest(properties);
        return clusterProperties;
    }

    public static Properties oneNode() {
        return ClusterProperties.oneNode(PORT_TO_USE);
    }

    public static Properties oneNode(AtomicInteger portSeed) {
        java.util.Properties properties = new java.util.Properties();
        properties = ClusterProperties.common(ClusterProperties.oneOnly(properties, portSeed), 1);
        Properties clusterProperties = Properties.openForTest(properties);
        return clusterProperties;
    }

    private static java.util.Properties oneOnly(java.util.Properties properties, AtomicInteger portSeed) {
        properties.setProperty("node.node1.id", "1");
        properties.setProperty("node.node1.name", "node1");
        properties.setProperty("node.node1.host", "localhost");
        properties.setProperty("node.node1.op.port", ClusterProperties.nextPortToUseString(portSeed));
        properties.setProperty("node.node1.app.port", ClusterProperties.nextPortToUseString(portSeed));
        return properties;
    }

    private static java.util.Properties allOf(java.util.Properties properties, AtomicInteger portSeed) {
        ClusterProperties.oneOnly(properties, portSeed);
        properties.setProperty("node.node2.id", "2");
        properties.setProperty("node.node2.name", "node2");
        properties.setProperty("node.node2.host", "localhost");
        properties.setProperty("node.node2.op.port", ClusterProperties.nextPortToUseString(portSeed));
        properties.setProperty("node.node2.app.port", ClusterProperties.nextPortToUseString(portSeed));
        properties.setProperty("node.node3.id", "3");
        properties.setProperty("node.node3.name", "node3");
        properties.setProperty("node.node3.host", "localhost");
        properties.setProperty("node.node3.op.port", ClusterProperties.nextPortToUseString(portSeed));
        properties.setProperty("node.node3.app.port", ClusterProperties.nextPortToUseString(portSeed));
        return properties;
    }

    private static java.util.Properties common(java.util.Properties properties, int totalNodes) {
        properties.setProperty("cluster.ssl", "false");
        properties.setProperty("cluster.op.buffer.size", "4096");
        properties.setProperty("cluster.app.buffer.size", "10240");
        properties.setProperty("cluster.op.outgoing.pooled.buffers", "20");
        properties.setProperty("cluster.app.outgoing.pooled.buffers", "50");
        properties.setProperty("cluster.msg.charset", "UTF-8");
        properties.setProperty("cluster.app.class", "io.vlingo.cluster.model.application.FakeClusterApplicationActor");
        properties.setProperty("cluster.app.stage", "fake.app.stage");
        properties.setProperty("cluster.health.check.interval", "2000");
        properties.setProperty("cluster.live.node.timeout", "20000");
        properties.setProperty("cluster.heartbeat.interval", "7000");
        properties.setProperty("cluster.quorum.timeout", "60000");
        if (totalNodes == 1) {
            properties.setProperty("cluster.seedNodes", "node1");
        } else if (totalNodes == 3) {
            properties.setProperty("cluster.seedNodes", "node1,node2,node3");
        } else {
            throw new IllegalArgumentException("The totalNodes must be 1 or 3.");
        }
        return properties;
    }

    private static int nextPortToUse(AtomicInteger portSeed) {
        return portSeed.incrementAndGet();
    }

    private static String nextPortToUseString(AtomicInteger portSeed) {
        return "" + ClusterProperties.nextPortToUse(portSeed);
    }
}

