/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster;

import io.vlingo.actors.Logger;
import io.vlingo.actors.World;
import io.vlingo.cluster.ShutdownHook;
import io.vlingo.cluster.model.Cluster;
import io.vlingo.cluster.model.ClusterSnapshotControl;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.application.ClusterApplication;
import io.vlingo.common.Tuple2;

public final class NodeBootstrap {
    private final Tuple2<ClusterSnapshotControl, Logger> clusterSnapshotControl;

    public static void main(String[] args) throws Exception {
        if (args.length == 1) {
            NodeBootstrap.boot(args[0]);
        } else if (args.length > 1) {
            System.err.println("vlingo/cluster: Too many arguments; provide node name only.");
            System.exit(1);
        } else {
            System.err.println("vlingo/cluster: This node must be named with a command-line argument.");
            System.exit(1);
        }
    }

    public static NodeBootstrap boot(String nodeName) throws Exception {
        return NodeBootstrap.boot(nodeName, false);
    }

    public static NodeBootstrap boot(String nodeName, boolean embedded) throws Exception {
        return NodeBootstrap.boot(World.start((String)"vlingo-cluster"), nodeName, embedded);
    }

    public static NodeBootstrap boot(World world, String nodeName, boolean embedded) throws Exception {
        return NodeBootstrap.boot(World.start((String)"vlingo-cluster"), new ClusterApplication.DefaultClusterApplicationInstantiator(), Properties.instance, nodeName, embedded);
    }

    public static NodeBootstrap boot(World world, ClusterApplication.ClusterApplicationInstantiator<?> instantiator, Properties properties, String nodeName, boolean embedded) throws Exception {
        Properties.instance.validateRequired(nodeName);
        Tuple2<ClusterSnapshotControl, Logger> control = Cluster.controlFor(world, instantiator, properties, nodeName);
        NodeBootstrap instance = new NodeBootstrap(control, nodeName);
        ((Logger)control._2).info("Successfully started cluster node: '" + nodeName + "'");
        if (!embedded) {
            ((Logger)control._2).info("==========");
        }
        return instance;
    }

    public ClusterSnapshotControl clusterSnapshotControl() {
        return (ClusterSnapshotControl)this.clusterSnapshotControl._1;
    }

    private NodeBootstrap(Tuple2<ClusterSnapshotControl, Logger> control, String nodeName) throws Exception {
        this.clusterSnapshotControl = control;
        ShutdownHook shutdownHook = new ShutdownHook(nodeName, control);
        shutdownHook.register();
    }
}

