/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model;

import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Stage;
import io.vlingo.actors.World;
import io.vlingo.cluster.model.ClusterSnapshotActor;
import io.vlingo.cluster.model.ClusterSnapshotControl;
import io.vlingo.cluster.model.ClusterSnapshotInitializer;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.application.ClusterApplication;
import io.vlingo.common.Tuple2;
import java.util.UUID;

public class Cluster {
    static final String INTERNAL_NAME = UUID.randomUUID().toString();

    public static synchronized Tuple2<ClusterSnapshotControl, Logger> controlFor(ClusterApplication.ClusterApplicationInstantiator<?> instantiator, Properties properties, String nodeName) throws Exception {
        return Cluster.controlFor(World.start((String)"vlingo-cluster"), instantiator, properties, nodeName);
    }

    public static synchronized Tuple2<ClusterSnapshotControl, Logger> controlFor(World world, ClusterApplication.ClusterApplicationInstantiator<?> instantiator, Properties properties, String nodeName) throws Exception {
        return Cluster.controlFor(world, world.stage(), instantiator, properties, nodeName);
    }

    public static synchronized Tuple2<ClusterSnapshotControl, Logger> controlFor(World world, Stage stage, ClusterApplication.ClusterApplicationInstantiator<?> instantiator, Properties properties, String nodeName) {
        if (Cluster.isRunningInside(world)) {
            throw new IllegalArgumentException("Cluster is already running inside World: " + world.name());
        }
        Tuple2<ClusterSnapshotControl, Logger> control = ClusterSnapshotControl.instance(world, instantiator, properties, nodeName);
        world.registerDynamic(INTERNAL_NAME, control._1);
        return control;
    }

    public static boolean isRunningInside(World world) {
        return world.resolveDynamic(INTERNAL_NAME, ClusterSnapshotControl.class) != null;
    }

    static class ClusterSnapshotActorInstantiator
    implements ActorInstantiator<ClusterSnapshotActor> {
        private static final long serialVersionUID = 6105119774787607965L;
        private final ClusterApplication clusterApplication;
        private final ClusterSnapshotInitializer initializer;

        public ClusterSnapshotActorInstantiator(ClusterSnapshotInitializer initializer, ClusterApplication clusterApplication) {
            this.initializer = initializer;
            this.clusterApplication = clusterApplication;
        }

        public ClusterSnapshotActor instantiate() {
            try {
                return new ClusterSnapshotActor(this.initializer, this.clusterApplication);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to instantiate " + this.type() + " because: " + e.getMessage(), e);
            }
        }

        public Class<ClusterSnapshotActor> type() {
            return ClusterSnapshotActor.class;
        }
    }
}

