/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model;

import io.vlingo.actors.Logger;
import io.vlingo.cluster.model.application.ClusterApplication;
import io.vlingo.cluster.model.attribute.AttributesProtocol;
import io.vlingo.wire.fdx.outbound.ApplicationOutboundStream;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

class ClusterApplicationBroadcaster
implements ClusterApplication {
    private List<ClusterApplication> clusterApplications;
    private final Logger logger;

    ClusterApplicationBroadcaster(Logger logger) {
        this.logger = logger;
        this.clusterApplications = new ArrayList<ClusterApplication>();
    }

    public void registerClusterApplication(ClusterApplication clusterApplication) {
        this.clusterApplications.add(clusterApplication);
    }

    @Override
    public void informAllLiveNodes(Collection<Node> liveNodes, boolean isHealthyCluster) {
        this.broadcast(app -> app.informAllLiveNodes(liveNodes, isHealthyCluster));
    }

    @Override
    public void informLeaderElected(Id leaderId, boolean isHealthyCluster, boolean isLocalNodeLeading) {
        this.broadcast(app -> app.informLeaderElected(leaderId, isHealthyCluster, isLocalNodeLeading));
    }

    @Override
    public void informLeaderLost(Id lostLeaderId, boolean isHealthyCluster) {
        this.broadcast(app -> app.informLeaderLost(lostLeaderId, isHealthyCluster));
    }

    @Override
    public void informLocalNodeShutDown(Id nodeId) {
        this.broadcast(app -> app.informLocalNodeShutDown(nodeId));
    }

    @Override
    public void informLocalNodeStarted(Id nodeId) {
        this.broadcast(app -> app.informLocalNodeStarted(nodeId));
    }

    @Override
    public void informNodeIsHealthy(Id nodeId, boolean isHealthyCluster) {
        this.broadcast(app -> app.informNodeIsHealthy(nodeId, isHealthyCluster));
    }

    @Override
    public void informNodeJoinedCluster(Id nodeId, boolean isHealthyCluster) {
        this.broadcast(app -> app.informNodeJoinedCluster(nodeId, isHealthyCluster));
    }

    @Override
    public void informNodeLeftCluster(Id nodeId, boolean isHealthyCluster) {
        this.broadcast(app -> app.informNodeLeftCluster(nodeId, isHealthyCluster));
    }

    @Override
    public void informQuorumAchieved() {
        this.broadcast(ClusterApplication::informQuorumAchieved);
    }

    @Override
    public void informQuorumLost() {
        this.broadcast(ClusterApplication::informQuorumLost);
    }

    @Override
    public void informResponder(ApplicationOutboundStream responder) {
        this.broadcast(app -> app.informResponder(responder));
    }

    @Override
    public void informAttributesClient(AttributesProtocol client) {
        this.broadcast(app -> app.informAttributesClient(client));
    }

    @Override
    public void informAttributeSetCreated(String attributeSetName) {
        this.broadcast(app -> app.informAttributeSetCreated(attributeSetName));
    }

    @Override
    public void informAttributeAdded(String attributeSetName, String attributeName) {
        this.broadcast(app -> app.informAttributeAdded(attributeSetName, attributeName));
    }

    @Override
    public void informAttributeRemoved(String attributeSetName, String attributeName) {
        this.broadcast(app -> app.informAttributeRemoved(attributeSetName, attributeName));
    }

    @Override
    public void informAttributeSetRemoved(String attributeSetName) {
        this.broadcast(app -> app.informAttributeSetRemoved(attributeSetName));
    }

    @Override
    public void informAttributeReplaced(String attributeSetName, String attributeName) {
        this.broadcast(app -> app.informAttributeReplaced(attributeSetName, attributeName));
    }

    public void start() {
    }

    public void conclude() {
    }

    public boolean isStopped() {
        return false;
    }

    public void stop() {
    }

    @Override
    public void handleApplicationMessage(RawMessage message) {
        this.broadcast(app -> app.handleApplicationMessage(message));
    }

    private void broadcast(Consumer<ClusterApplication> inform) {
        for (ClusterApplication app : this.clusterApplications) {
            try {
                inform.accept(app);
            }
            catch (Exception e) {
                this.logger.error("Cannot inform because: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

