/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model;

import io.vlingo.actors.Logger;
import io.vlingo.cluster.model.Properties;
import io.vlingo.wire.node.Address;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Host;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Name;
import io.vlingo.wire.node.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public class ClusterConfiguration
implements Configuration {
    private final Logger logger;
    private final Set<Node> nodes;

    public ClusterConfiguration(Properties properties, Logger logger) {
        this.logger = logger;
        this.nodes = new TreeSet<Node>();
        this.initializeConfiguredNodeEntries(properties);
    }

    public Set<Node> allNodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public Set<Node> allNodesOf(Collection<Id> ids) {
        return new TreeSet<Node>();
    }

    public final Set<Node> allOtherNodes(Id nodeId) {
        TreeSet<Node> except = new TreeSet<Node>();
        for (Node node : this.nodes) {
            if (node.id().equals((Object)nodeId)) continue;
            except.add(node);
        }
        return except;
    }

    public Set<Id> allOtherNodesId(Id nodeId) {
        TreeSet<Id> ids = new TreeSet<Id>();
        for (Node node : this.allOtherNodes(nodeId)) {
            ids.add(node.id());
        }
        return ids;
    }

    public final Set<Node> allGreaterNodes(Id nodeId) {
        TreeSet<Node> greater = new TreeSet<Node>();
        for (Node node : this.nodes) {
            if (!node.id().greaterThan(nodeId)) continue;
            greater.add(node);
        }
        return greater;
    }

    public Set<String> allNodeNames() {
        TreeSet<String> names = new TreeSet<String>();
        for (Node node : this.nodes) {
            names.add(node.name().value());
        }
        return names;
    }

    public final Node nodeMatching(Id nodeId) {
        for (Node node : this.nodes) {
            if (!node.id().equals((Object)nodeId)) continue;
            return node;
        }
        return Node.NO_NODE;
    }

    public final Id greatestNodeId() {
        Id greatest = Id.NO_ID;
        for (Node node : this.nodes) {
            if (!node.id().greaterThan(greatest)) continue;
            greatest = node.id();
        }
        return greatest;
    }

    public boolean hasNode(Id nodeId) {
        for (Node node : this.nodes) {
            if (!node.id().equals((Object)nodeId)) continue;
            return true;
        }
        return false;
    }

    public int totalNodes() {
        return this.nodes.size();
    }

    public Logger logger() {
        return this.logger;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != ClusterConfiguration.class) {
            return false;
        }
        return this.nodes.equals(((ClusterConfiguration)other).nodes);
    }

    public int hashCode() {
        return 31 * this.nodes.hashCode();
    }

    public String toString() {
        return "ConfiguredCluster[" + this.nodes + "]";
    }

    private void initializeConfiguredNodeEntries(Properties properties) {
        for (String configuredNodeName : properties.seedNodes()) {
            Id nodeId = Id.of((short)properties.nodeId(configuredNodeName));
            Name nodeName = new Name(configuredNodeName);
            Host host = Host.of((String)properties.host(configuredNodeName));
            Address opNodeAddress = Address.from((Host)host, (int)properties.operationalPort(configuredNodeName), (AddressType)AddressType.OP);
            Address appNodeAddress = Address.from((Host)host, (int)properties.applicationPort(configuredNodeName), (AddressType)AddressType.APP);
            this.nodes.add(new Node(nodeId, nodeName, opNodeAddress, appNodeAddress));
        }
    }
}

