/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model;

import io.vlingo.actors.Actor;
import io.vlingo.cluster.model.ClusterApplicationBroadcaster;
import io.vlingo.cluster.model.ClusterSnapshot;
import io.vlingo.cluster.model.ClusterSnapshotControl;
import io.vlingo.cluster.model.ClusterSnapshotInitializer;
import io.vlingo.cluster.model.CommunicationsHub;
import io.vlingo.cluster.model.application.ClusterApplication;
import io.vlingo.cluster.model.attribute.AttributesAgent;
import io.vlingo.cluster.model.message.OperationalMessage;
import io.vlingo.cluster.model.node.LocalLiveNode;
import io.vlingo.cluster.model.node.MergeResult;
import io.vlingo.cluster.model.node.RegistryInterest;
import io.vlingo.wire.fdx.inbound.InboundStreamInterest;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Node;
import java.util.Collection;

public class ClusterSnapshotActor
extends Actor
implements ClusterSnapshot,
ClusterSnapshotControl,
InboundStreamInterest,
RegistryInterest {
    private final AttributesAgent attributesAgent;
    private final ClusterApplication clusterApplication;
    private final ClusterApplicationBroadcaster broadcaster = new ClusterApplicationBroadcaster(this.logger());
    private final CommunicationsHub communicationsHub;
    private final LocalLiveNode localLiveNode;
    private final Node localNode;

    public ClusterSnapshotActor(ClusterSnapshotInitializer initializer, ClusterApplication clusterApplication) throws Exception {
        this.communicationsHub = initializer.communicationsHub();
        this.communicationsHub.open(this.stage(), initializer.localNode(), (InboundStreamInterest)this.selfAs(InboundStreamInterest.class), initializer.configuration());
        this.localNode = initializer.localNode();
        this.clusterApplication = clusterApplication;
        this.broadcaster.registerClusterApplication(clusterApplication);
        clusterApplication.start();
        clusterApplication.informResponder(this.communicationsHub.applicationOutboundStream());
        initializer.registry().registerRegistryInterest((RegistryInterest)this.selfAs(RegistryInterest.class));
        this.attributesAgent = AttributesAgent.instance(this.stage(), this.localNode, this.broadcaster, this.communicationsHub.operationalOutboundStream(), initializer.configuration());
        this.localLiveNode = LocalLiveNode.instance(this.stage(), this.localNode, (ClusterSnapshot)this.selfAs(ClusterSnapshot.class), initializer.registry(), this.communicationsHub.operationalOutboundStream(), initializer.configuration());
        this.localLiveNode.registerNodeSynchronizer(this.attributesAgent);
        this.communicationsHub.start();
    }

    @Override
    public void quorumAchieved() {
        this.broadcaster.informQuorumAchieved();
    }

    @Override
    public void quorumLost() {
        this.broadcaster.informQuorumLost();
    }

    @Override
    public void shutDown() {
        if (this.isStopped()) {
            return;
        }
        this.localLiveNode.stop();
        this.clusterApplication.stop();
        this.attributesAgent.stop();
        this.communicationsHub.close();
        this.stop();
        this.stage().world().terminate();
    }

    public void handleInboundStreamMessage(AddressType addressType, RawMessage message) {
        if (this.isStopped()) {
            return;
        }
        if (addressType.isOperational()) {
            String textMessage = message.asTextMessage();
            OperationalMessage typedMessage = OperationalMessage.messageFrom(textMessage);
            if (typedMessage != null) {
                if (typedMessage.isApp()) {
                    this.attributesAgent.handleInboundStreamMessage(addressType, message);
                } else {
                    this.localLiveNode.handle(typedMessage);
                }
            } else {
                this.logger().warn("ClusterSnapshot received invalid raw message '{}'", new Object[]{textMessage});
            }
        } else if (addressType.isApplication()) {
            this.clusterApplication.handleApplicationMessage(message);
        } else {
            this.logger().warn("ClusterSnapshot couldn't dispatch incoming message; unknown address type: " + addressType + " for message: " + message.asTextMessage());
        }
    }

    @Override
    public void informAllLiveNodes(Collection<Node> liveNodes, boolean isHealthyCluster) {
        this.broadcaster.informAllLiveNodes(liveNodes, isHealthyCluster);
    }

    @Override
    public void informConfirmedByLeader(Node node, boolean isHealthyCluster) {
        this.broadcaster.informNodeIsHealthy(node.id(), isHealthyCluster);
    }

    @Override
    public void informCurrentLeader(Node node, boolean isHealthyCluster) {
        this.broadcaster.informLeaderElected(node.id(), isHealthyCluster, node.id().equals((Object)this.localNode.id()));
    }

    @Override
    public void informMergedAllDirectoryEntries(Collection<Node> liveNodes, Collection<MergeResult> mergeResults, boolean isHealthyCluster) {
        for (MergeResult mergeResult : mergeResults) {
            if (mergeResult.left()) {
                this.broadcaster.informNodeLeftCluster(mergeResult.node().id(), isHealthyCluster);
                continue;
            }
            if (!mergeResult.joined()) continue;
            this.broadcaster.informNodeJoinedCluster(mergeResult.node().id(), isHealthyCluster);
        }
    }

    @Override
    public void informLeaderDemoted(Node node, boolean isHealthyCluster) {
        this.broadcaster.informLeaderLost(node.id(), isHealthyCluster);
    }

    @Override
    public void informNodeIsHealthy(Node node, boolean isHealthyCluster) {
        this.broadcaster.informNodeIsHealthy(node.id(), isHealthyCluster);
    }

    @Override
    public void informNodeJoinedCluster(Node node, boolean isHealthyCluster) {
        this.broadcaster.informNodeJoinedCluster(node.id(), isHealthyCluster);
    }

    @Override
    public void informNodeLeftCluster(Node node, boolean isHealthyCluster) {
        this.broadcaster.informNodeLeftCluster(node.id(), isHealthyCluster);
    }

    @Override
    public void informNodeTimedOut(Node node, boolean isHealthyCluster) {
        this.broadcaster.informNodeLeftCluster(node.id(), isHealthyCluster);
    }
}

