/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model;

import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Logger;
import io.vlingo.actors.Stage;
import io.vlingo.actors.World;
import io.vlingo.cluster.model.ClusterSnapshotActor;
import io.vlingo.cluster.model.ClusterSnapshotInitializer;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.application.ClusterApplication;
import io.vlingo.common.Tuple2;

public interface ClusterSnapshotControl {
    public static Tuple2<ClusterSnapshotControl, Logger> instance(World world, ClusterApplication.ClusterApplicationInstantiator<?> instantiator, Properties properties, String nodeName) {
        String stageName = properties.clusterApplicationStageName();
        Stage stage = world.stageNamed(stageName);
        return ClusterSnapshotControl.instance(world, stage, instantiator, properties, nodeName);
    }

    public static Tuple2<ClusterSnapshotControl, Logger> instance(World world, Stage stage, ClusterApplication.ClusterApplicationInstantiator<?> instantiator, Properties properties, String nodeName) {
        ClusterSnapshotInitializer initializer = new ClusterSnapshotInitializer(nodeName, properties, world.defaultLogger());
        instantiator.node(initializer.localNode());
        ClusterApplication application = ClusterApplication.instance(stage, instantiator);
        Definition definition = new Definition(ClusterSnapshotActor.class, (ActorInstantiator)new ClusterSnapshotInstantiator(initializer, application), "cluster-snapshot-" + nodeName);
        ClusterSnapshotControl control = (ClusterSnapshotControl)world.actorFor(ClusterSnapshotControl.class, definition);
        return Tuple2.from((Object)control, (Object)world.defaultLogger());
    }

    public void shutDown();

    public static class ClusterSnapshotInstantiator
    implements ActorInstantiator<ClusterSnapshotActor> {
        private static final long serialVersionUID = -5766576644564817563L;
        final ClusterApplication application;
        final ClusterSnapshotInitializer initializer;

        public ClusterSnapshotInstantiator(ClusterSnapshotInitializer initializer, ClusterApplication application) {
            this.initializer = initializer;
            this.application = application;
        }

        public ClusterSnapshotActor instantiate() {
            try {
                return new ClusterSnapshotActor(this.initializer, this.application);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to instantiate " + this.type() + " because: " + e.getMessage(), e);
            }
        }

        public Class<ClusterSnapshotActor> type() {
            return ClusterSnapshotActor.class;
        }
    }
}

