/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model;

import io.vlingo.actors.Logger;
import io.vlingo.cluster.model.ClusterConfiguration;
import io.vlingo.cluster.model.CommunicationsHub;
import io.vlingo.cluster.model.NetworkCommunicationsHub;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.node.LocalRegistry;
import io.vlingo.cluster.model.node.Registry;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Node;

class ClusterSnapshotInitializer {
    private final CommunicationsHub communicationsHub;
    private final Configuration configuration;
    private final Node localNode;
    private final Id localNodeId;
    private final Registry registry;

    ClusterSnapshotInitializer(String nodeNameText, Properties properties, Logger logger) {
        this.localNodeId = Id.of((short)properties.nodeId(nodeNameText));
        this.configuration = new ClusterConfiguration(properties, logger);
        this.localNode = this.configuration.nodeMatching(this.localNodeId);
        this.communicationsHub = new NetworkCommunicationsHub(properties);
        this.registry = new LocalRegistry(this.localNode, this.configuration, logger);
    }

    CommunicationsHub communicationsHub() {
        return this.communicationsHub;
    }

    Configuration configuration() {
        return this.configuration;
    }

    Node localNode() {
        return this.localNode;
    }

    Id localNodeId() {
        return this.localNodeId;
    }

    Registry registry() {
        return this.registry;
    }
}

