/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model;

import io.vlingo.actors.Logger;
import io.vlingo.actors.Stage;
import io.vlingo.cluster.model.CommunicationsHub;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.outbound.OperationalOutboundStream;
import io.vlingo.common.pool.ElasticResourcePool;
import io.vlingo.common.pool.ResourcePool;
import io.vlingo.wire.fdx.inbound.InboundChannelReaderProvider;
import io.vlingo.wire.fdx.inbound.InboundStream;
import io.vlingo.wire.fdx.inbound.InboundStreamInterest;
import io.vlingo.wire.fdx.inbound.rsocket.RSocketInboundChannelReaderProvider;
import io.vlingo.wire.fdx.outbound.ApplicationOutboundStream;
import io.vlingo.wire.fdx.outbound.ManagedOutboundChannelProvider;
import io.vlingo.wire.fdx.outbound.rsocket.ManagedOutboundRSocketChannelProvider;
import io.vlingo.wire.message.ConsumerByteBuffer;
import io.vlingo.wire.message.ConsumerByteBufferPool;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Node;

class NetworkCommunicationsHub
implements CommunicationsHub {
    static final String APP_NAME = "APP";
    static final String OP_NAME = "OP";
    private InboundStream applicationInboundStream;
    private ApplicationOutboundStream applicationOutboundStream;
    private InboundStream operationalInboundStream;
    private OperationalOutboundStream operationalOutboundStream;
    private final Properties properties;

    NetworkCommunicationsHub(Properties properties) {
        this.properties = properties;
    }

    @Override
    public void close() {
        this.operationalInboundStream.stop();
        this.operationalOutboundStream.stop();
        this.applicationInboundStream.stop();
        this.applicationOutboundStream.stop();
    }

    @Override
    public void open(Stage stage, Node node, InboundStreamInterest interest, Configuration configuration) throws Exception {
        Logger logger = stage.world().defaultLogger();
        this.operationalInboundStream = InboundStream.instance((Stage)stage, (InboundChannelReaderProvider)new RSocketInboundChannelReaderProvider(this.properties.operationalBufferSize(), logger), (InboundStreamInterest)interest, (int)node.operationalAddress().port(), (AddressType)AddressType.OP, (String)OP_NAME, (long)this.properties.operationalInboundProbeInterval());
        this.operationalOutboundStream = OperationalOutboundStream.instance(stage, node, (ManagedOutboundChannelProvider)new ManagedOutboundRSocketChannelProvider(node, AddressType.OP, configuration), (ResourcePool<ConsumerByteBuffer, String>)new ConsumerByteBufferPool(ElasticResourcePool.Config.of((int)this.properties.operationalOutgoingPooledBuffers()), this.properties.operationalBufferSize()));
        this.applicationInboundStream = InboundStream.instance((Stage)stage, (InboundChannelReaderProvider)new RSocketInboundChannelReaderProvider(this.properties.applicationBufferSize(), logger), (InboundStreamInterest)interest, (int)node.applicationAddress().port(), (AddressType)AddressType.APP, (String)APP_NAME, (long)this.properties.applicationInboundProbeInterval());
        this.applicationOutboundStream = ApplicationOutboundStream.instance((Stage)stage, (ManagedOutboundChannelProvider)new ManagedOutboundRSocketChannelProvider(node, AddressType.APP, configuration), (ResourcePool)new ConsumerByteBufferPool(ElasticResourcePool.Config.of((int)this.properties.applicationOutgoingPooledBuffers()), this.properties.applicationBufferSize()));
    }

    @Override
    public InboundStream applicationInboundStream() {
        return this.applicationInboundStream;
    }

    @Override
    public ApplicationOutboundStream applicationOutboundStream() {
        return this.applicationOutboundStream;
    }

    @Override
    public InboundStream operationalInboundStream() {
        return this.operationalInboundStream;
    }

    @Override
    public OperationalOutboundStream operationalOutboundStream() {
        return this.operationalOutboundStream;
    }

    @Override
    public void start() {
    }
}

