/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model;

import io.vlingo.actors.Actor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Properties {
    public static final Properties instance = Properties.open();
    private static final String propertiesFile = "/vlingo-cluster.properties";
    private final java.util.Properties properties;

    public static Properties open() {
        java.util.Properties properties = new java.util.Properties();
        try {
            properties.load(Properties.class.getResourceAsStream(propertiesFile));
        }
        catch (IOException e) {
            throw new IllegalStateException("Must provide properties file on classpath: /vlingo-cluster.properties");
        }
        return new Properties(properties);
    }

    public static Properties openForTest(java.util.Properties properties) {
        return new Properties(properties);
    }

    public int applicationBufferSize() {
        return this.getInteger("cluster.app.buffer.size", 10240);
    }

    public long applicationInboundProbeInterval() {
        int probeInterval = this.getInteger("cluster.app.incoming.probe.interval", 100);
        if (probeInterval == 0) {
            throw new IllegalStateException("Must assign an application (app) incoming probe interval in properties file.");
        }
        return probeInterval;
    }

    public int applicationOutgoingPooledBuffers() {
        int pooledBuffers = this.getInteger("cluster.app.outgoing.pooled.buffers", 50);
        if (pooledBuffers == 0) {
            throw new IllegalStateException("Must assign an application (app) pooled buffers size in properties file.");
        }
        return pooledBuffers;
    }

    public int applicationPort(String nodeName) {
        int port = this.getInteger(nodeName, "app.port", 0);
        if (port == 0) {
            throw new IllegalStateException("Must assign an application (app) port to node '" + nodeName + "' in properties file.");
        }
        return port;
    }

    public Class<Actor> clusterApplicationClass() {
        String classname = this.clusterApplicationClassname();
        try {
            return Class.forName(classname);
        }
        catch (Exception e) {
            throw new IllegalStateException("Must define property: cluster.app.class", e);
        }
    }

    public final String clusterApplicationClassname() {
        String classname = this.getString("cluster.app.class", "");
        if (classname.length() == 0) {
            throw new IllegalStateException("Must assign a cluster app class in properties file.");
        }
        return classname;
    }

    public final String clusterApplicationStageName() {
        String name = this.getString("cluster.app.stage", "");
        if (name.length() == 0) {
            throw new IllegalStateException("Must assign a cluster app stage name in properties file.");
        }
        return name;
    }

    public long clusterAttributesRedistributionInterval() {
        return this.getInteger("cluster.attributes.redistribution.interval", 1000).intValue();
    }

    public int clusterAttributesRedistributionRetries() {
        return this.getInteger("cluster.attributes.redistribution.retries", 10);
    }

    public long clusterHealthCheckInterval() {
        return this.getInteger("cluster.health.check.interval", 3000).intValue();
    }

    public long clusterHeartbeatInterval() {
        return this.getInteger("cluster.heartbeat.interval", 7000).intValue();
    }

    public long clusterLiveNodeTimeout() {
        return this.getInteger("cluster.live.node.timeout", 20000).intValue();
    }

    public long clusterQuorumTimeout() {
        return this.getInteger("cluster.quorum.timeout", 60000).intValue();
    }

    public final String host(String nodeName) {
        String host = this.getString(nodeName, "host", "");
        if (host.length() == 0) {
            throw new IllegalStateException("Must assign a host to node '" + nodeName + "' in properties file.");
        }
        return host;
    }

    public short nodeId(String nodeName) {
        int nodeId = this.getInteger(nodeName, "id", -1);
        if (nodeId == -1) {
            throw new IllegalStateException("Must assign an id to node '" + nodeName + "' in properties file.");
        }
        return (short)nodeId;
    }

    public final String nodeName(String nodeName) {
        String name = this.getString(nodeName, "name", "");
        if (name.length() == 0) {
            throw new IllegalStateException("Must assign a name to node '" + nodeName + "' in properties file.");
        }
        return name;
    }

    public int operationalBufferSize() {
        return this.getInteger("cluster.op.buffer.size", 4096);
    }

    public long operationalInboundProbeInterval() {
        int probeInterval = this.getInteger("cluster.op.incoming.probe.interval", 100);
        if (probeInterval == 0) {
            throw new IllegalStateException("Must assign an operational (op) incoming probe interval in properties file.");
        }
        return probeInterval;
    }

    public int operationalOutgoingPooledBuffers() {
        int pooledBuffers = this.getInteger("cluster.op.outgoing.pooled.buffers", 20);
        if (pooledBuffers == 0) {
            throw new IllegalStateException("Must assign an operational (op) pooled buffers size in properties file.");
        }
        return pooledBuffers;
    }

    public int operationalPort(String nodeName) {
        int port = this.getInteger(nodeName, "op.port", 0);
        if (port == 0) {
            throw new IllegalStateException("Must assign an operational (op) port to node '" + nodeName + "' in properties file.");
        }
        return port;
    }

    public final List<String> seedNodes() {
        ArrayList<String> seedNodes = new ArrayList<String>();
        String commaSeparated = this.getString("cluster.seedNodes", "");
        if (commaSeparated.length() == 0) {
            throw new IllegalStateException("Must declare seed nodes in properties file.");
        }
        for (String seedNode : commaSeparated.split(",")) {
            seedNodes.add(seedNode.trim());
        }
        return seedNodes;
    }

    public boolean useSSL() {
        return this.getBoolean("cluster.ssl", false);
    }

    public final Boolean getBoolean(String nodeName, String key, Boolean defaultValue) {
        String value = this.getString(nodeName, key, defaultValue.toString());
        return Boolean.parseBoolean(value);
    }

    public final Boolean getBoolean(String key, Boolean defaultValue) {
        return this.getBoolean("", key, defaultValue);
    }

    public Float getFloat(String nodeName, String key, Float defaultValue) {
        String value = this.getString(nodeName, key, defaultValue.toString());
        return Float.valueOf(Float.parseFloat(value));
    }

    public final Float getFloat(String key, Float defaultValue) {
        return this.getFloat("", key, defaultValue);
    }

    public final Integer getInteger(String nodeName, String key, Integer defaultValue) {
        String value = this.getString(nodeName, key, defaultValue.toString());
        return Integer.parseInt(value);
    }

    public final Integer getInteger(String key, Integer defaultValue) {
        return this.getInteger("", key, defaultValue);
    }

    public final String getString(String nodeName, String key, String defaultValue) {
        return this.properties.getProperty(this.key(nodeName, key), defaultValue);
    }

    public final String getString(String key, String defaultValue) {
        return this.properties.getProperty(key, defaultValue);
    }

    public void validateRequired(String nodeName) {
        this.nodeName(nodeName);
        this.nodeId(nodeName);
        this.host(nodeName);
        this.operationalPort(nodeName);
        this.applicationPort(nodeName);
        this.seedNodes();
        this.clusterApplicationClassname();
    }

    private Properties(java.util.Properties properties) {
        this.properties = properties;
    }

    private String key(String nodeName, String key) {
        if (nodeName == null || nodeName.length() == 0) {
            return key;
        }
        return "node." + nodeName + "." + key;
    }
}

