/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.application;

import io.vlingo.actors.Actor;
import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Stage;
import io.vlingo.actors.Startable;
import io.vlingo.actors.Stoppable;
import io.vlingo.actors.World;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.application.FakeClusterApplicationActor;
import io.vlingo.cluster.model.attribute.AttributesProtocol;
import io.vlingo.wire.fdx.outbound.ApplicationOutboundStream;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Node;
import java.util.Collection;

public interface ClusterApplication
extends Startable,
Stoppable {
    public static ClusterApplication instance(World world, ClusterApplicationInstantiator<?> instantiator, Properties properties, Node node) {
        Stage applicationStage = world.stageNamed(properties.clusterApplicationStageName());
        return (ClusterApplication)applicationStage.actorFor(ClusterApplication.class, Definition.has(instantiator.type(), instantiator, (String)"cluster-application"));
    }

    public static <A extends Actor> ClusterApplication instance(Stage applicationStage, ActorInstantiator<A> instantator) {
        return (ClusterApplication)applicationStage.actorFor(ClusterApplication.class, Definition.has((Class)instantator.type(), instantator, (String)"cluster-application"));
    }

    public void handleApplicationMessage(RawMessage var1);

    public void informAllLiveNodes(Collection<Node> var1, boolean var2);

    public void informLeaderElected(Id var1, boolean var2, boolean var3);

    public void informLeaderLost(Id var1, boolean var2);

    public void informLocalNodeShutDown(Id var1);

    public void informLocalNodeStarted(Id var1);

    public void informNodeIsHealthy(Id var1, boolean var2);

    public void informNodeJoinedCluster(Id var1, boolean var2);

    public void informNodeLeftCluster(Id var1, boolean var2);

    public void informQuorumAchieved();

    public void informQuorumLost();

    public void informResponder(ApplicationOutboundStream var1);

    public void informAttributesClient(AttributesProtocol var1);

    public void informAttributeSetCreated(String var1);

    public void informAttributeAdded(String var1, String var2);

    public void informAttributeRemoved(String var1, String var2);

    public void informAttributeSetRemoved(String var1);

    public void informAttributeReplaced(String var1, String var2);

    public static class DefaultClusterApplicationInstantiator
    extends ClusterApplicationInstantiator<FakeClusterApplicationActor> {
        private static final long serialVersionUID = -4275208628986318945L;

        public DefaultClusterApplicationInstantiator() {
            super(FakeClusterApplicationActor.class);
        }

        public FakeClusterApplicationActor instantiate() {
            return new FakeClusterApplicationActor(this.node());
        }
    }

    public static abstract class ClusterApplicationInstantiator<A extends Actor>
    implements ActorInstantiator<A> {
        private static final long serialVersionUID = -2002705648453794614L;
        private Node node;
        private final Class<A> type;

        public ClusterApplicationInstantiator(Class<A> type) {
            this.type = type;
        }

        public Node node() {
            return this.node;
        }

        public void node(Node node) {
            this.node = node;
        }

        public Class<A> type() {
            return this.type;
        }
    }
}

