/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.application;

import io.vlingo.cluster.model.application.ClusterApplicationAdapter;
import io.vlingo.cluster.model.attribute.Attribute;
import io.vlingo.cluster.model.attribute.AttributesProtocol;
import io.vlingo.wire.fdx.outbound.ApplicationOutboundStream;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Node;
import java.util.Collection;

public class FakeClusterApplicationActor
extends ClusterApplicationAdapter {
    private AttributesProtocol client;
    private final Node localNode;

    public FakeClusterApplicationActor(Node localNode) {
        this.localNode = localNode;
    }

    @Override
    public void start() {
        this.logger().debug("APP: ClusterApplication started on node: " + this.localNode);
    }

    @Override
    public void handleApplicationMessage(RawMessage message) {
        this.logger().debug("APP: Received application message: " + message.asTextMessage());
    }

    @Override
    public void informAllLiveNodes(Collection<Node> liveNodes, boolean isHealthyCluster) {
        for (Node id : liveNodes) {
            this.logger().debug("APP: Live node confirmed: " + id);
        }
        this.printHealthy(isHealthyCluster);
    }

    @Override
    public void informLeaderElected(Id leaderId, boolean isHealthyCluster, boolean isLocalNodeLeading) {
        this.logger().debug("APP: Leader elected: " + leaderId);
        this.printHealthy(isHealthyCluster);
        if (isLocalNodeLeading) {
            this.logger().debug("APP: Local node is leading.");
        }
    }

    @Override
    public void informLeaderLost(Id lostLeaderId, boolean isHealthyCluster) {
        this.logger().debug("APP: Leader lost: " + lostLeaderId);
        this.printHealthy(isHealthyCluster);
    }

    @Override
    public void informLocalNodeShutDown(Id nodeId) {
        this.logger().debug("APP: Local node shut down: " + nodeId);
    }

    @Override
    public void informLocalNodeStarted(Id nodeId) {
        this.logger().debug("APP: Local node started: " + nodeId);
    }

    @Override
    public void informNodeIsHealthy(Id nodeId, boolean isHealthyCluster) {
        this.logger().debug("APP: Node reported healthy: " + nodeId);
        this.printHealthy(isHealthyCluster);
    }

    @Override
    public void informNodeJoinedCluster(Id nodeId, boolean isHealthyCluster) {
        this.logger().debug("APP: " + nodeId + " joined cluster");
        this.printHealthy(isHealthyCluster);
    }

    @Override
    public void informNodeLeftCluster(Id nodeId, boolean isHealthyCluster) {
        this.logger().debug("APP: " + nodeId + " left cluster");
        this.printHealthy(isHealthyCluster);
    }

    @Override
    public void informQuorumAchieved() {
        this.logger().debug("APP: Quorum achieved");
        this.printHealthy(true);
    }

    @Override
    public void informQuorumLost() {
        this.logger().debug("APP: Quorum lost");
        this.printHealthy(false);
    }

    @Override
    public void informResponder(ApplicationOutboundStream responder) {
        this.logger().debug("APP: Informed of responder: " + responder);
    }

    @Override
    public void informAttributesClient(AttributesProtocol client) {
        this.logger().debug("APP: Attributes Client received.");
        this.client = client;
        if (this.localNode.id().value() == 1) {
            client.add("fake.set", "fake.attribute.name1", "value1");
            client.add("fake.set", "fake.attribute.name2", "value2");
        }
    }

    @Override
    public void informAttributeSetCreated(String attributeSetName) {
        this.logger().debug("APP: Attributes Set Created: " + attributeSetName);
    }

    @Override
    public void informAttributeAdded(String attributeSetName, String attributeName) {
        Attribute attr = this.client.attribute(attributeSetName, attributeName);
        this.logger().debug("APP: Attribute Set " + attributeSetName + " Attribute Added: " + attributeName + " Value: " + (String)attr.value);
        if (this.localNode.id().value() == 1) {
            this.client.replace("fake.set", "fake.attribute.name1", "value-replaced-2");
            this.client.replace("fake.set", "fake.attribute.name2", "value-replaced-20");
        }
    }

    @Override
    public void informAttributeRemoved(String attributeSetName, String attributeName) {
        Attribute attr = this.client.attribute(attributeSetName, attributeName);
        this.logger().debug("APP: Attribute Set " + attributeSetName + " Attribute Removed: " + attributeName + " Attribute: " + attr);
    }

    @Override
    public void informAttributeSetRemoved(String attributeSetName) {
        this.logger().debug("APP: Attributes Set Removed: " + attributeSetName);
    }

    @Override
    public void informAttributeReplaced(String attributeSetName, String attributeName) {
        Attribute attr = this.client.attribute(attributeSetName, attributeName);
        this.logger().debug("APP: Attribute Set " + attributeSetName + " Attribute Replaced: " + attributeName + " Value: " + (String)attr.value);
        if (this.localNode.id().value() == 1) {
            this.client.remove("fake.set", "fake.attribute.name1");
        }
    }

    private void printHealthy(boolean isHealthyCluster) {
        if (isHealthyCluster) {
            this.logger().debug("APP: Cluster is healthy");
        } else {
            this.logger().debug("APP: Cluster is NOT healthy");
        }
    }
}

