/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute;

public final class Attribute<T> {
    public static final Attribute<?> Undefined = Attribute.from("__undefined", Type.String, "");
    public final String name;
    public final Type type;
    public final T value;

    public static <T> Attribute<T> from(String name, T value) {
        return new Attribute<T>(name, value, Attribute.typeOf(value.getClass()));
    }

    public static Attribute<?> from(String name, Type type, String value) {
        Object typedValue = Attribute.typeValue(type, value);
        return new Attribute<Object>(name, typedValue, type);
    }

    static Type typeOfAttribute(String classnameOfType) {
        try {
            Class<?> classOfType = Class.forName(classnameOfType);
            return Attribute.typeOf(classOfType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The type '" + classnameOfType + "' is not recognized.");
        }
    }

    private static Type typeOf(Class<?> type) {
        switch (type.getName()) {
            case "java.lang.String": {
                return Type.String;
            }
            case "int": 
            case "java.lang.Integer": {
                return Type.Integer;
            }
            case "long": 
            case "java.lang.Long": {
                return Type.Long;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return Type.Boolean;
            }
            case "byte": 
            case "java.lang.Byte": {
                return Type.Byte;
            }
            case "double": 
            case "java.lang.Double": {
                return Type.Double;
            }
            case "float": 
            case "java.lang.Float": {
                return Type.Float;
            }
            case "short": 
            case "java.lang.Short": {
                return Type.Short;
            }
            case "char": 
            case "java.lang.Character": {
                return Type.Character;
            }
        }
        throw new IllegalArgumentException("The type '" + type.getName() + "' is not recognized.");
    }

    private static Object typeValue(Type type, String value) {
        switch (type) {
            case String: {
                return value;
            }
            case Integer: {
                return Integer.parseInt(value);
            }
            case Long: {
                return Long.parseLong(value);
            }
            case Boolean: {
                return Boolean.parseBoolean(value);
            }
            case Byte: {
                return Byte.parseByte(value);
            }
            case Double: {
                return Double.parseDouble(value);
            }
            case Float: {
                return Float.valueOf(Float.parseFloat(value));
            }
            case Short: {
                return Short.parseShort(value);
            }
            case Character: {
                return Character.valueOf(value.charAt(0));
            }
        }
        throw new IllegalArgumentException();
    }

    public Attribute(String name, T value, Type type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public boolean isUndefined() {
        return this == Undefined;
    }

    public Attribute<?> replacingValueWith(Attribute<?> other) {
        if (this.type != other.type) {
            throw new IllegalArgumentException("Source and target attributes have different types.");
        }
        return new Attribute<T>(this.name, other.value, this.type);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.value.hashCode() + this.type.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != Attribute.class) {
            return false;
        }
        Attribute otherAttribute = (Attribute)other;
        return this.name.equals(otherAttribute.name) && this.value.equals(otherAttribute.value) && this.type.ordinal() == otherAttribute.type.ordinal();
    }

    public String toString() {
        return "Attribute[name=" + this.name + ", value=" + this.value + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static enum Type {
        Byte{

            @Override
            public boolean isByte() {
                return true;
            }
        }
        ,
        Short{

            @Override
            public boolean isShort() {
                return true;
            }
        }
        ,
        Integer{

            @Override
            public boolean isInteger() {
                return true;
            }
        }
        ,
        Long{

            @Override
            public boolean isLong() {
                return true;
            }
        }
        ,
        Character{

            @Override
            public boolean isCharacter() {
                return true;
            }
        }
        ,
        Float{

            @Override
            public boolean isFloat() {
                return true;
            }
        }
        ,
        Double{

            @Override
            public boolean isDouble() {
                return true;
            }
        }
        ,
        Boolean{

            @Override
            public boolean isBoolean() {
                return true;
            }
        }
        ,
        String{

            @Override
            public boolean isString() {
                return true;
            }
        };


        public boolean isByte() {
            return false;
        }

        public boolean isShort() {
            return false;
        }

        public boolean isInteger() {
            return false;
        }

        public boolean isLong() {
            return false;
        }

        public boolean isCharacter() {
            return false;
        }

        public boolean isFloat() {
            return false;
        }

        public boolean isDouble() {
            return false;
        }

        public boolean isBoolean() {
            return false;
        }

        public boolean isString() {
            return false;
        }

        public String typeClassname() {
            return "java.lang." + this.name();
        }
    }
}

