/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute;

import io.vlingo.cluster.model.attribute.Attribute;
import io.vlingo.cluster.model.attribute.TrackedAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class AttributeSet {
    static final AttributeSet None = AttributeSet.named("__none");
    public final String name;
    private final Map<String, TrackedAttribute> attributes;

    public static AttributeSet named(String name) {
        return new AttributeSet(name);
    }

    public TrackedAttribute addIfAbsent(Attribute<?> attribute) {
        TrackedAttribute maybeAttribute = this.find(attribute);
        if (maybeAttribute.isAbsent()) {
            TrackedAttribute nowPresent = TrackedAttribute.of(this, attribute);
            this.attributes.put(nowPresent.id, nowPresent);
            return nowPresent;
        }
        return maybeAttribute;
    }

    public Collection<TrackedAttribute> all() {
        return this.attributes.values();
    }

    public TrackedAttribute attributeNamed(String name) {
        return this.find(name);
    }

    public AttributeSet copy(AttributeSet source) {
        AttributeSet target = AttributeSet.named(source.name);
        for (TrackedAttribute attribute : source.attributes.values()) {
            target.attributes.put(attribute.id, attribute);
        }
        return target;
    }

    public boolean isDefined() {
        return !this.isNone();
    }

    public boolean isNone() {
        return this == None;
    }

    public TrackedAttribute remove(Attribute<?> attribute) {
        TrackedAttribute maybeAttribute = this.find(attribute);
        if (maybeAttribute.isPresent()) {
            return this.attributes.remove(maybeAttribute.id);
        }
        return maybeAttribute;
    }

    public TrackedAttribute replace(Attribute<?> attribute) {
        TrackedAttribute maybeAttribute = this.find(attribute);
        if (maybeAttribute.isPresent()) {
            TrackedAttribute newlyTracked = maybeAttribute.withAttribute(attribute);
            this.attributes.put(maybeAttribute.id, newlyTracked);
            return newlyTracked;
        }
        return maybeAttribute;
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.attributes.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != AttributeSet.class) {
            return false;
        }
        AttributeSet otherAttributeSet = (AttributeSet)other;
        return this.name.equals(otherAttributeSet.name) && this.attributes.equals(otherAttributeSet.attributes);
    }

    public String toString() {
        return "AttributeSet[name=" + this.name + ", attributes=[" + this.attributes + "]]";
    }

    private AttributeSet(String name) {
        this.name = name;
        this.attributes = new ConcurrentHashMap<String, TrackedAttribute>(128, 0.75f, 16);
    }

    private TrackedAttribute find(Attribute<?> attribute) {
        return this.find(attribute.name);
    }

    private TrackedAttribute find(String name) {
        for (TrackedAttribute id : this.attributes.values()) {
            if (!id.attribute.name.equals(name)) continue;
            return id;
        }
        return TrackedAttribute.Absent;
    }
}

