/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute;

import io.vlingo.cluster.model.attribute.AttributeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class AttributeSetRepository {
    private final Map<String, AttributeSet> all = new ConcurrentHashMap<String, AttributeSet>(16, 0.75f, 16);

    AttributeSetRepository() {
    }

    void add(AttributeSet set) {
        this.all.put(set.name, set);
    }

    Collection<AttributeSet> all() {
        return new ArrayList<AttributeSet>(this.all.values());
    }

    AttributeSet attributeSetOf(String name) {
        return this.all.getOrDefault(name, AttributeSet.None);
    }

    void remove(String name) {
        this.all.remove(name);
    }

    void removeAll() {
        this.all.clear();
    }

    void syncWith(AttributeSet set) {
        this.all.put(set.name, set);
    }
}

