/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute;

import io.vlingo.actors.Actor;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.application.ClusterApplication;
import io.vlingo.cluster.model.attribute.Attribute;
import io.vlingo.cluster.model.attribute.AttributeSet;
import io.vlingo.cluster.model.attribute.AttributeSetRepository;
import io.vlingo.cluster.model.attribute.AttributesAgent;
import io.vlingo.cluster.model.attribute.AttributesClient;
import io.vlingo.cluster.model.attribute.ConfirmationInterest;
import io.vlingo.cluster.model.attribute.ConfirmingDistributor;
import io.vlingo.cluster.model.attribute.NoOpConfirmationInterest;
import io.vlingo.cluster.model.attribute.RemoteAttributeRequestHandler;
import io.vlingo.cluster.model.attribute.TrackedAttribute;
import io.vlingo.cluster.model.attribute.message.ApplicationMessageType;
import io.vlingo.cluster.model.attribute.message.ReceivedAttributeMessage;
import io.vlingo.cluster.model.outbound.OperationalOutboundStream;
import io.vlingo.common.Scheduled;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.AddressType;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Node;

public class AttributesAgentActor
extends Actor
implements AttributesAgent {
    private final AttributesClient client;
    private final Configuration configuration;
    private final ConfirmationInterest confirmationInterest;
    private final ConfirmingDistributor confirmingDistributor;
    private final Node node;
    private final RemoteAttributeRequestHandler remoteRequestHandler;
    private final AttributeSetRepository repository;

    public AttributesAgentActor(Node node, ClusterApplication application, OperationalOutboundStream outbound, Configuration configuration) {
        this(node, application, outbound, configuration, new NoOpConfirmationInterest(configuration));
    }

    public AttributesAgentActor(Node node, ClusterApplication application, OperationalOutboundStream outbound, Configuration configuration, ConfirmationInterest confirmationInterest) {
        this.node = node;
        this.configuration = configuration;
        this.confirmationInterest = confirmationInterest;
        this.client = AttributesClient.with((AttributesAgent)this.selfAs(AttributesAgent.class));
        this.confirmingDistributor = new ConfirmingDistributor(application, node, outbound, configuration);
        this.repository = new AttributeSetRepository();
        this.remoteRequestHandler = new RemoteAttributeRequestHandler(this.confirmingDistributor, configuration, this.repository);
        application.informAttributesClient(this.client);
        this.stage().scheduler().schedule((Scheduled)this.selfAs(Scheduled.class), null, 1000L, Properties.instance.clusterAttributesRedistributionInterval());
    }

    @Override
    public <T> void add(String attributeSetName, String attributeName, T value) {
        AttributeSet set = this.repository.attributeSetOf(attributeSetName);
        if (set.isNone()) {
            AttributeSet newSet = AttributeSet.named(attributeSetName);
            newSet.addIfAbsent(Attribute.from(attributeName, value));
            this.repository.add(newSet);
            this.client.syncWith(newSet);
            this.confirmingDistributor.distributeCreate(newSet);
        } else {
            TrackedAttribute newlyTracked = set.addIfAbsent(Attribute.from(attributeName, value));
            if (!newlyTracked.isDistributed()) {
                this.confirmingDistributor.distribute(set, newlyTracked, ApplicationMessageType.AddAttribute);
            }
        }
    }

    @Override
    public <T> void replace(String attributeSetName, String attributeName, T value) {
        TrackedAttribute newlyTracked;
        Attribute<T> other;
        TrackedAttribute tracked;
        AttributeSet set = this.repository.attributeSetOf(attributeSetName);
        if (!set.isNone() && (tracked = set.attributeNamed(attributeName)).isPresent() && !tracked.sameAs(other = Attribute.from(attributeName, value)) && (newlyTracked = set.replace(tracked.replacingValueWith(other))).isPresent()) {
            this.client.syncWith(set);
            this.confirmingDistributor.distribute(set, newlyTracked, ApplicationMessageType.ReplaceAttribute);
        }
    }

    @Override
    public <T> void remove(String attributeSetName, String attributeName) {
        TrackedAttribute untracked;
        TrackedAttribute tracked;
        AttributeSet set = this.repository.attributeSetOf(attributeSetName);
        if (!set.isNone() && (tracked = set.attributeNamed(attributeName)).isPresent() && (untracked = set.remove(tracked.attribute)).isPresent()) {
            this.client.syncWith(set);
            this.confirmingDistributor.distribute(set, untracked, ApplicationMessageType.RemoveAttribute);
        }
    }

    @Override
    public <T> void removeAll(String attributeSetName) {
        AttributeSet set = this.repository.attributeSetOf(attributeSetName);
        if (!set.isNone()) {
            this.repository.remove(attributeSetName);
            this.client.syncWithout(set);
            this.confirmingDistributor.distributeRemove(set);
        }
    }

    public void synchronize(Node nodeToSynchronize) {
        if (!this.node.equals((Object)nodeToSynchronize)) {
            this.confirmingDistributor.synchronizeTo(this.repository.all(), nodeToSynchronize);
        }
    }

    public void handleInboundStreamMessage(AddressType addressType, RawMessage message) {
        if (addressType.isOperational()) {
            ReceivedAttributeMessage request = new ReceivedAttributeMessage(message);
            ApplicationMessageType type = request.type();
            switch (type) {
                case CreateAttributeSet: {
                    this.remoteRequestHandler.createAttributeSet(request);
                    break;
                }
                case AddAttribute: {
                    this.remoteRequestHandler.addAttribute(request);
                    break;
                }
                case ReplaceAttribute: {
                    this.remoteRequestHandler.replaceAttribute(request);
                    break;
                }
                case RemoveAttribute: {
                    this.remoteRequestHandler.removeAttribute(request);
                    break;
                }
                case RemoveAttributeSet: {
                    this.remoteRequestHandler.removeAttributeSet(request);
                    break;
                }
                case ConfirmCreateAttributeSet: 
                case ConfirmAddAttribute: 
                case ConfirmReplaceAttribute: 
                case ConfirmRemoveAttribute: 
                case ConfirmRemoveAttributeSet: {
                    this.confirmingDistributor.acknowledgeConfirmation(request.correlatingMessageId(), this.configuration.nodeMatching(request.sourceNodeId()));
                    this.confirmationInterest.confirm(request.sourceNodeId(), request.attributeSetName(), request.attributeName(), type);
                    break;
                }
                default: {
                    this.configuration.logger().warn("Received unknown message: " + type.name());
                }
            }
        }
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        this.confirmingDistributor.redistributeUnconfirmed();
    }

    public void stop() {
        if (this.isStopped()) {
            return;
        }
        this.repository.removeAll();
        super.stop();
    }
}

