/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute;

import io.vlingo.cluster.model.attribute.Attribute;
import io.vlingo.cluster.model.attribute.AttributeSet;
import io.vlingo.cluster.model.attribute.AttributeSetRepository;
import io.vlingo.cluster.model.attribute.AttributesAgent;
import io.vlingo.cluster.model.attribute.AttributesProtocol;
import io.vlingo.cluster.model.attribute.TrackedAttribute;
import java.util.ArrayList;
import java.util.Collection;

public final class AttributesClient
implements AttributesProtocol {
    final AttributesAgent agent;
    final AttributeSetRepository repository;

    static synchronized AttributesClient with(AttributesAgent agent) {
        return new AttributesClient(agent, new AttributeSetRepository());
    }

    @Override
    public <T> void add(String attributeSetName, String attributeName, T value) {
        this.agent.add(attributeSetName, attributeName, value);
    }

    @Override
    public Collection<AttributeSet> all() {
        return this.repository.all();
    }

    @Override
    public Collection<Attribute<?>> allOf(String attributeSetName) {
        ArrayList all = new ArrayList();
        AttributeSet set = this.repository.attributeSetOf(attributeSetName);
        if (set.isDefined()) {
            for (TrackedAttribute tracked : set.all()) {
                if (!tracked.isPresent()) continue;
                all.add(tracked.attribute);
            }
        }
        return all;
    }

    @Override
    public <T> Attribute<T> attribute(String attributeSetName, String attributeName) {
        TrackedAttribute tracked;
        AttributeSet set = this.repository.attributeSetOf(attributeSetName);
        if (set.isDefined() && (tracked = set.attributeNamed(attributeName)).isPresent()) {
            return tracked.attribute;
        }
        return Attribute.Undefined;
    }

    @Override
    public <T> void replace(String attributeSetName, String attributeName, T value) {
        this.agent.replace(attributeSetName, attributeName, value);
    }

    @Override
    public <T> void remove(String attributeSetName, String attributeName) {
        this.agent.remove(attributeSetName, attributeName);
    }

    @Override
    public <T> void removeAll(String attributeSetName) {
        this.agent.removeAll(attributeSetName);
    }

    public String toString() {
        return "AttributesClient[agent=" + this.agent + " repository=" + this.repository + "]";
    }

    void syncWith(AttributeSet set) {
        this.repository.syncWith(set.copy(set));
    }

    void syncWithout(AttributeSet set) {
        this.repository.remove(set.name);
    }

    private AttributesClient(AttributesAgent agent, AttributeSetRepository repository) {
        this.agent = agent;
        this.repository = repository;
    }
}

