/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute;

import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.attribute.message.ApplicationMessage;
import io.vlingo.wire.node.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class Confirmables {
    private final Collection<Node> allOtherNodes;
    private final List<Confirmable> expectedConfirmables;
    private final Node node;

    Confirmables(Node node, Collection<Node> allOtherNodes) {
        this.node = node;
        this.allOtherNodes = allOtherNodes;
        this.expectedConfirmables = new ArrayList<Confirmable>();
    }

    Collection<Confirmable> allRedistributable() {
        ArrayList<Confirmable> ready = new ArrayList<Confirmable>();
        for (Confirmable confirmable : this.expectedConfirmables) {
            if (!confirmable.isRedistributableAsOf()) continue;
            ready.add(confirmable);
        }
        return ready;
    }

    Collection<String> allTrackingIds() {
        ArrayList<String> all = new ArrayList<String>();
        for (Confirmable confirmable : this.expectedConfirmables) {
            all.add(((Confirmable)confirmable).message.trackingId);
        }
        return all;
    }

    void confirm(String trackingId, Node node) {
        Confirmable confirmable = this.confirmableOf(trackingId);
        confirmable.confirm(node);
        if (!confirmable.hasUnconfirmedNodes()) {
            this.expectedConfirmables.remove(confirmable);
        }
    }

    Confirmable confirmableOf(String trackingId) {
        for (Confirmable confirmable : this.expectedConfirmables) {
            if (!confirmable.trackingId.equals(trackingId)) continue;
            return confirmable;
        }
        return Confirmable.NoConfirmable;
    }

    Confirmable unconfirmed(ApplicationMessage message) {
        return this.unconfirmedFor(message, this.allOtherNodes);
    }

    Confirmable unconfirmedFor(ApplicationMessage message, Collection<Node> nodes) {
        if (nodes.contains(this.node)) {
            new Exception().printStackTrace();
        }
        Confirmable confirmable = new Confirmable(message, nodes);
        this.expectedConfirmables.add(confirmable);
        return confirmable;
    }

    static final class Confirmable {
        static final int TotalRetries = Properties.instance.clusterAttributesRedistributionRetries();
        static final Confirmable NoConfirmable = new Confirmable();
        private final long createdOn;
        private final ApplicationMessage message;
        private final String trackingId;
        private Map<Node, Integer> unconfirmedNodes;

        Confirmable(ApplicationMessage message, Collection<Node> allOtherNodes) {
            this.message = message;
            this.unconfirmedNodes = this.allUnconfirmedFor(allOtherNodes);
            this.createdOn = System.currentTimeMillis();
            this.trackingId = message.trackingId;
        }

        private Confirmable() {
            this.message = null;
            this.unconfirmedNodes = new HashMap<Node, Integer>(0);
            this.createdOn = 0L;
            this.trackingId = "";
        }

        private Map<Node, Integer> allUnconfirmedFor(Collection<Node> allOtherNodes) {
            HashMap<Node, Integer> allUnconfirmed = new HashMap<Node, Integer>(allOtherNodes.size());
            for (Node node : allOtherNodes) {
                allUnconfirmed.put(node, 0);
            }
            return allUnconfirmed;
        }

        void confirm(Node node) {
            this.unconfirmedNodes.remove(node);
        }

        boolean hasUnconfirmedNodes() {
            return !this.unconfirmedNodes.isEmpty();
        }

        ApplicationMessage message() {
            return this.message;
        }

        boolean isRedistributableAsOf() {
            long targetTime = this.createdOn + Properties.instance.clusterAttributesRedistributionInterval();
            if (targetTime < System.currentTimeMillis()) {
                HashMap<Node, Integer> allUnconfirmed = new HashMap<Node, Integer>(this.unconfirmedNodes.size());
                for (Node node : this.unconfirmedNodes.keySet()) {
                    int tries = this.unconfirmedNodes.get(node) + 1;
                    if (tries > TotalRetries) continue;
                    allUnconfirmed.put(node, tries);
                }
                this.unconfirmedNodes = allUnconfirmed;
                return true;
            }
            return false;
        }

        Collection<Node> unconfirmedNodes() {
            return this.unconfirmedNodes.keySet();
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != Confirmable.class) {
                return false;
            }
            return this.trackingId.equals(((Confirmable)other).trackingId);
        }

        public String toString() {
            return "Confirmable[trackingId=" + this.trackingId + " nodes=" + this.unconfirmedNodes + "]";
        }
    }
}

