/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute;

import io.vlingo.actors.Logger;
import io.vlingo.cluster.model.application.ClusterApplication;
import io.vlingo.cluster.model.attribute.AttributeSet;
import io.vlingo.cluster.model.attribute.Confirmables;
import io.vlingo.cluster.model.attribute.TrackedAttribute;
import io.vlingo.cluster.model.attribute.message.AddAttribute;
import io.vlingo.cluster.model.attribute.message.ApplicationMessageType;
import io.vlingo.cluster.model.attribute.message.ConfirmAttribute;
import io.vlingo.cluster.model.attribute.message.ConfirmCreateAttributeSet;
import io.vlingo.cluster.model.attribute.message.ConfirmRemoveAttributeSet;
import io.vlingo.cluster.model.attribute.message.CreateAttributeSet;
import io.vlingo.cluster.model.attribute.message.RemoveAttribute;
import io.vlingo.cluster.model.attribute.message.RemoveAttributeSet;
import io.vlingo.cluster.model.attribute.message.ReplaceAttribute;
import io.vlingo.cluster.model.message.ApplicationSays;
import io.vlingo.cluster.model.outbound.OperationalOutboundStream;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Node;
import java.util.Collection;

public final class ConfirmingDistributor {
    private final ClusterApplication application;
    private final Confirmables confirmables;
    private final Collection<Node> allOtherNodes;
    private final Logger logger;
    private final Node node;
    private final OperationalOutboundStream outbound;

    ConfirmingDistributor(ClusterApplication application, Node node, OperationalOutboundStream outbound, Configuration configuration) {
        this.application = application;
        this.logger = configuration.logger();
        this.node = node;
        this.outbound = outbound;
        this.allOtherNodes = configuration.allOtherNodes(node.id());
        this.confirmables = new Confirmables(node, this.allOtherNodes);
    }

    void acknowledgeConfirmation(String trackingId, Node node) {
        this.confirmables.confirm(trackingId, node);
    }

    Collection<String> allTrackingIds() {
        return this.confirmables.allTrackingIds();
    }

    void distributeCreate(AttributeSet set) {
        this.distributeTo(set, this.allOtherNodes);
    }

    public void distributeRemove(AttributeSet set) {
        this.distributeRemoveTo(set, this.allOtherNodes);
    }

    void distributeTo(AttributeSet set, Collection<Node> nodes) {
        CreateAttributeSet create = new CreateAttributeSet(this.node, set);
        Confirmables.Confirmable confirmable = this.confirmables.unconfirmedFor(create, nodes);
        this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), create.toPayload()), confirmable.unconfirmedNodes());
        this.application.informAttributeSetCreated(set.name);
        for (TrackedAttribute tracked : set.all()) {
            this.distributeTo(set, tracked, ApplicationMessageType.AddAttribute, nodes);
        }
    }

    void distributeRemoveTo(AttributeSet set, Collection<Node> nodes) {
        for (TrackedAttribute untracked : set.all()) {
            this.distributeTo(set, untracked, ApplicationMessageType.RemoveAttribute, nodes);
        }
        RemoveAttributeSet removeSet = new RemoveAttributeSet(this.node, set);
        Confirmables.Confirmable confirmable = this.confirmables.unconfirmedFor(removeSet, nodes);
        this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), removeSet.toPayload()), confirmable.unconfirmedNodes());
        this.application.informAttributeSetRemoved(set.name);
    }

    void distribute(AttributeSet set, TrackedAttribute tracked, ApplicationMessageType type) {
        this.distributeTo(set, tracked, type, this.allOtherNodes);
    }

    void distributeTo(AttributeSet set, TrackedAttribute tracked, ApplicationMessageType type, Collection<Node> nodes) {
        switch (type) {
            case AddAttribute: {
                AddAttribute add = AddAttribute.from(this.node, set, tracked);
                Confirmables.Confirmable addConfirmable = this.confirmables.unconfirmedFor(add, nodes);
                this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), add.toPayload()), addConfirmable.unconfirmedNodes());
                this.application.informAttributeAdded(set.name, tracked.attribute.name);
                break;
            }
            case RemoveAttribute: {
                RemoveAttribute remove = RemoveAttribute.from(this.node, set, tracked);
                Confirmables.Confirmable removeConfirmable = this.confirmables.unconfirmedFor(remove, nodes);
                this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), remove.toPayload()), removeConfirmable.unconfirmedNodes());
                this.application.informAttributeRemoved(set.name, tracked.attribute.name);
                break;
            }
            case RemoveAttributeSet: {
                RemoveAttributeSet removeSet = RemoveAttributeSet.from(this.node, set);
                Confirmables.Confirmable removeSetConfirmable = this.confirmables.unconfirmedFor(removeSet, nodes);
                this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), removeSet.toPayload()), removeSetConfirmable.unconfirmedNodes());
                this.application.informAttributeSetRemoved(set.name);
                break;
            }
            case ReplaceAttribute: {
                ReplaceAttribute replace = ReplaceAttribute.from(this.node, set, tracked);
                Confirmables.Confirmable replaceConfirmable = this.confirmables.unconfirmedFor(replace, nodes);
                this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), replace.toPayload()), replaceConfirmable.unconfirmedNodes());
                this.application.informAttributeReplaced(set.name, tracked.attribute.name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot distribute unknown ApplicationMessageType.");
            }
        }
    }

    void confirmCreate(String correlatingMessageId, AttributeSet set, Node toOriginalSource) {
        ConfirmCreateAttributeSet confirm = new ConfirmCreateAttributeSet(correlatingMessageId, this.node, set);
        this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), confirm.toPayload()), toOriginalSource.collected());
        this.application.informAttributeSetCreated(set.name);
    }

    void confirmRemove(String correlatingMessageId, AttributeSet set, Node toOriginalSource) {
        ConfirmRemoveAttributeSet confirm = new ConfirmRemoveAttributeSet(correlatingMessageId, this.node, set);
        this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), confirm.toPayload()), toOriginalSource.collected());
        this.application.informAttributeSetRemoved(set.name);
    }

    void confirm(String correlatingMessageId, AttributeSet set, TrackedAttribute tracked, ApplicationMessageType type, Node toOriginalSource) {
        switch (type) {
            case AddAttribute: {
                ConfirmAttribute confirmAdd = ConfirmAttribute.from(correlatingMessageId, toOriginalSource, set, tracked, ApplicationMessageType.ConfirmAddAttribute);
                this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), confirmAdd.toPayload()), toOriginalSource.collected());
                this.application.informAttributeAdded(set.name, tracked.attribute.name);
                break;
            }
            case RemoveAttribute: {
                ConfirmAttribute confirmRemove = ConfirmAttribute.from(correlatingMessageId, toOriginalSource, set, tracked, ApplicationMessageType.ConfirmRemoveAttribute);
                this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), confirmRemove.toPayload()), toOriginalSource.collected());
                this.application.informAttributeRemoved(set.name, tracked.attribute.name);
                break;
            }
            case ReplaceAttribute: {
                ConfirmAttribute confirmReplace = ConfirmAttribute.from(correlatingMessageId, toOriginalSource, set, tracked, ApplicationMessageType.ConfirmReplaceAttribute);
                this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), confirmReplace.toPayload()), toOriginalSource.collected());
                this.application.informAttributeReplaced(set.name, tracked.attribute.name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot confirm unknown ApplicationMessageType.");
            }
        }
    }

    void redistributeUnconfirmed() {
        for (Confirmables.Confirmable confirmable : this.confirmables.allRedistributable()) {
            if (!confirmable.hasUnconfirmedNodes()) continue;
            this.logger.trace("REDIST ATTR: " + confirmable);
            this.outbound.application(ApplicationSays.from(this.node.id(), this.node.name(), confirmable.message().toPayload()), confirmable.unconfirmedNodes());
        }
    }

    void synchronizeTo(Collection<AttributeSet> sets, Node targetNode) {
        Collection onlyOneTargetNode = targetNode.collected();
        for (AttributeSet set : sets) {
            this.distributeTo(set, onlyOneTargetNode);
        }
    }

    Collection<Node> unconfirmedNodesFor(String trackingId) {
        return this.confirmables.confirmableOf(trackingId).unconfirmedNodes();
    }
}

