/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute;

import io.vlingo.cluster.model.attribute.AttributeSet;
import io.vlingo.cluster.model.attribute.AttributeSetRepository;
import io.vlingo.cluster.model.attribute.ConfirmingDistributor;
import io.vlingo.cluster.model.attribute.TrackedAttribute;
import io.vlingo.cluster.model.attribute.message.ReceivedAttributeMessage;
import io.vlingo.wire.node.Configuration;

final class RemoteAttributeRequestHandler {
    private final Configuration configuration;
    private final ConfirmingDistributor confirmingDistributor;
    private final AttributeSetRepository repository;

    RemoteAttributeRequestHandler(ConfirmingDistributor confirmingDistributor, Configuration configuration, AttributeSetRepository repository) {
        this.confirmingDistributor = confirmingDistributor;
        this.configuration = configuration;
        this.repository = repository;
    }

    void addAttribute(ReceivedAttributeMessage request) {
        AttributeSet attributeSet = this.repository.attributeSetOf(request.attributeSetName());
        if (attributeSet.isNone()) {
            attributeSet = AttributeSet.named(request.attributeSetName());
            this.repository.add(attributeSet);
        }
        TrackedAttribute tracked = attributeSet.addIfAbsent(request.attribute());
        this.confirmingDistributor.confirm(request.trackingId(), attributeSet, tracked, request.type(), this.configuration.nodeMatching(request.sourceNodeId()));
    }

    void createAttributeSet(ReceivedAttributeMessage request) {
        AttributeSet attributeSet = this.repository.attributeSetOf(request.attributeSetName());
        if (attributeSet.isNone()) {
            attributeSet = AttributeSet.named(request.attributeSetName());
            this.repository.add(attributeSet);
        }
        this.confirmingDistributor.confirmCreate(request.trackingId(), attributeSet, this.configuration.nodeMatching(request.sourceNodeId()));
    }

    void removeAttributeSet(ReceivedAttributeMessage request) {
        AttributeSet attributeSet = this.repository.attributeSetOf(request.attributeSetName());
        if (attributeSet.isDefined()) {
            attributeSet = AttributeSet.named(request.attributeSetName());
            this.repository.remove(request.attributeSetName());
        }
        this.confirmingDistributor.confirmRemove(request.trackingId(), attributeSet, this.configuration.nodeMatching(request.sourceNodeId()));
    }

    void replaceAttribute(ReceivedAttributeMessage request) {
        TrackedAttribute tracked;
        AttributeSet attributeSet = this.repository.attributeSetOf(request.attributeSetName());
        if (attributeSet.isDefined() && (tracked = attributeSet.replace(request.attribute())).isPresent()) {
            this.confirmingDistributor.confirm(request.trackingId(), attributeSet, tracked, request.type(), this.configuration.nodeMatching(request.sourceNodeId()));
        }
    }

    void removeAttribute(ReceivedAttributeMessage request) {
        TrackedAttribute tracked;
        AttributeSet attributeSet = this.repository.attributeSetOf(request.attributeSetName());
        if (attributeSet.isDefined() && (tracked = attributeSet.remove(request.attribute())).isPresent()) {
            this.confirmingDistributor.confirm(request.trackingId(), attributeSet, tracked, request.type(), this.configuration.nodeMatching(request.sourceNodeId()));
        }
    }
}

