/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute;

import io.vlingo.cluster.model.attribute.Attribute;
import io.vlingo.cluster.model.attribute.AttributeSet;

public final class TrackedAttribute {
    public static final TrackedAttribute Absent = new TrackedAttribute(null, null);
    public final Attribute<?> attribute;
    public final boolean distributed;
    public final String id;

    static TrackedAttribute of(AttributeSet set, Attribute<?> attribute) {
        String tid = TrackedAttribute.trackedIdFor(set, attribute);
        return new TrackedAttribute(tid, attribute);
    }

    private static String trackedIdFor(AttributeSet set, Attribute<?> attribute) {
        return set.name + ":" + attribute.name;
    }

    public TrackedAttribute asDistributed() {
        return new TrackedAttribute(this.id, this.attribute, true);
    }

    public boolean isAbsent() {
        return this.attribute == null;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public boolean isPresent() {
        return !this.isAbsent();
    }

    public Attribute<?> replacingValueWith(Attribute<?> other) {
        return this.attribute.replacingValueWith(other);
    }

    public boolean sameAs(Attribute<?> other) {
        return this.attribute.equals(other);
    }

    public TrackedAttribute withAttribute(Attribute<?> attribute) {
        return new TrackedAttribute(this.id, attribute, false);
    }

    public int hashCode() {
        return 31 * this.attribute.hashCode() + Boolean.hashCode(this.distributed) + this.id.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != TrackedAttribute.class) {
            return false;
        }
        TrackedAttribute otherTracked = (TrackedAttribute)other;
        return this.attribute.equals(otherTracked.attribute) && this.distributed == otherTracked.distributed && this.id.equals(otherTracked.id);
    }

    public String toString() {
        return "TrackedAttribute[attribute=" + this.attribute + ", distributed=" + this.distributed + ", id=" + this.id + "]";
    }

    private TrackedAttribute(String id, Attribute<?> attribute) {
        this.attribute = attribute;
        this.distributed = false;
        this.id = attribute == null ? null : id;
    }

    private TrackedAttribute(String id, Attribute<?> attribute, boolean distributed) {
        this.attribute = attribute;
        this.distributed = distributed;
        this.id = id;
    }
}

