/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.attribute.message;

import io.vlingo.cluster.model.attribute.Attribute;
import io.vlingo.cluster.model.attribute.message.ApplicationMessageType;
import io.vlingo.cluster.model.message.ApplicationSays;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Name;
import java.util.HashMap;
import java.util.Map;

public final class ReceivedAttributeMessage {
    private static final String SourceNodeIdKey = "sourceNodeIdKey";
    private static final String SourceNodeNameKey = "sourceNodeNameKey";
    private static final String SourceNodeOpPortKey = "sourceNodeOpPortKey";
    private static final String SourceNodeAppPortKey = "sourceNodeAppPortKey";
    private static final String ClassOfMessageKey = "classOfMessage";
    private static final String CorrelatingMessageIdKey = "correlatingMessageId";
    private static final String MessageTypeKey = "type";
    private static final String TrackingIdKey = "trackingId";
    private static final String AttributeSetNameKey = "attributeSetName";
    private static final String AttributeNameKey = "attributeName";
    private static final String AttributeTypeKey = "attributeType";
    private static final String AttributeValueKey = "attributeValue";
    private final Map<String, String> payloadMap;

    public ReceivedAttributeMessage(RawMessage message) {
        this.payloadMap = this.parsePayload(message);
    }

    public final Id sourceNodeId() {
        return Id.of((int)Integer.parseInt(this.payloadMap.get(SourceNodeIdKey)));
    }

    public final Name sourceNodeName() {
        return Name.of((String)this.payloadMap.get(SourceNodeNameKey));
    }

    public final Id sourceNodeOpPort() {
        return Id.of((int)Integer.parseInt(this.payloadMap.get(SourceNodeOpPortKey)));
    }

    public final Id sourceNodeAppPort() {
        return Id.of((int)Integer.parseInt(this.payloadMap.get(SourceNodeAppPortKey)));
    }

    public final String classOfMessage() {
        return this.payloadMap.get(ClassOfMessageKey);
    }

    public final String correlatingMessageId() {
        return this.payloadMap.get(CorrelatingMessageIdKey);
    }

    public final String trackingId() {
        return this.payloadMap.get(TrackingIdKey);
    }

    public final ApplicationMessageType type() {
        return ApplicationMessageType.valueOf(this.payloadMap.get(MessageTypeKey));
    }

    public final Attribute<?> attribute() {
        Attribute.Type type = Attribute.Type.valueOf(Attribute.Type.class, this.attributeType());
        return Attribute.from(this.attributeName(), type, this.attributeValue());
    }

    public final String attributeSetName() {
        return this.payloadMap.get(AttributeSetNameKey);
    }

    public final String attributeName() {
        return this.payloadMap.get(AttributeNameKey);
    }

    public final String attributeType() {
        return this.payloadMap.get(AttributeTypeKey);
    }

    public final String attributeValue() {
        return this.payloadMap.get(AttributeValueKey);
    }

    public String toString() {
        return "ReceivedAttributeMessage[payloadMap=" + this.payloadMap + "]";
    }

    private Map<String, String> parsePayload(RawMessage message) {
        HashMap<String, String> map = new HashMap<String, String>();
        ApplicationSays says = ApplicationSays.from(message.asTextMessage());
        map.put(SourceNodeIdKey, says.id().valueString());
        map.put(SourceNodeNameKey, says.name().value());
        String[] parsed = says.payload().split("\n");
        map.put(ClassOfMessageKey, parsed[0]);
        switch (parsed[0]) {
            case "ConfirmCreateAttributeSet": 
            case "ConfirmRemoveAttributeSet": {
                map.put(CorrelatingMessageIdKey, parsed[1]);
                map.put(TrackingIdKey, parsed[2]);
                map.put(MessageTypeKey, parsed[3]);
                map.put(AttributeSetNameKey, parsed[4]);
                break;
            }
            case "ConfirmAttribute": {
                map.put(CorrelatingMessageIdKey, parsed[1]);
                map.put(TrackingIdKey, parsed[2]);
                map.put(MessageTypeKey, parsed[3]);
                map.put(AttributeSetNameKey, parsed[4]);
                map.put(AttributeNameKey, parsed[5]);
                break;
            }
            case "CreateAttributeSet": 
            case "RemoveAttributeSet": {
                map.put(TrackingIdKey, parsed[1]);
                map.put(MessageTypeKey, parsed[2]);
                map.put(AttributeSetNameKey, parsed[3]);
                break;
            }
            case "AddAttribute": 
            case "RemoveAttribute": 
            case "ReplaceAttribute": {
                map.put(CorrelatingMessageIdKey, parsed[1]);
                map.put(TrackingIdKey, parsed[2]);
                map.put(MessageTypeKey, parsed[3]);
                map.put(AttributeSetNameKey, parsed[4]);
                map.put(AttributeNameKey, parsed[5]);
                map.put(AttributeTypeKey, parsed[6]);
                map.put(AttributeValueKey, parsed[7]);
            }
        }
        return map;
    }
}

