/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.message;

import io.vlingo.cluster.model.message.OperationalMessage;
import io.vlingo.cluster.model.message.OperationalMessagePartsBuilder;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Name;
import java.util.UUID;

public final class ApplicationSays
extends OperationalMessage {
    public final Name name;
    public final String payload;
    public final String saysId;

    public static ApplicationSays from(String content) {
        Id id = OperationalMessagePartsBuilder.idFrom(content);
        Name name = OperationalMessagePartsBuilder.nameFrom(content);
        String saysId = OperationalMessagePartsBuilder.saysIdFrom(content);
        String payload = OperationalMessagePartsBuilder.payloadFrom(content);
        return new ApplicationSays(id, name, saysId, payload);
    }

    public static ApplicationSays from(Id id, Name name, String payload) {
        return new ApplicationSays(id, name, payload);
    }

    private ApplicationSays(Id id, Name name, String payload) {
        super(id);
        this.name = name;
        this.payload = payload;
        this.saysId = UUID.randomUUID().toString();
    }

    private ApplicationSays(Id id, Name name, String saysId, String payload) {
        super(id);
        this.name = name;
        this.saysId = saysId;
        this.payload = payload;
    }

    @Override
    public boolean isApp() {
        return true;
    }

    public final Name name() {
        return this.name;
    }

    public final String payload() {
        return this.payload;
    }

    public final String saysId() {
        return this.saysId;
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != ApplicationSays.class) {
            return false;
        }
        ApplicationSays otherAppSaid = (ApplicationSays)other;
        return this.name.equals((Object)otherAppSaid.name) && this.payload.equals(otherAppSaid.payload);
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.payload.hashCode();
    }

    public String toString() {
        return "ApplicationSays[" + this.id() + "," + this.name + "," + this.payload + "]";
    }
}

