/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.message;

import io.vlingo.cluster.model.message.OperationalMessage;
import io.vlingo.cluster.model.message.OperationalMessagePartsBuilder;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Name;
import io.vlingo.wire.node.Node;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class Directory
extends OperationalMessage {
    private final Name name;
    private final Set<Node> nodes;

    public static Directory from(String content) {
        Id id = OperationalMessagePartsBuilder.idFrom(content);
        Name name = OperationalMessagePartsBuilder.nameFrom(content);
        Set<Node> nodes = OperationalMessagePartsBuilder.nodesFrom(content);
        return new Directory(id, name, nodes);
    }

    public Directory(Id id, Name name, Set<Node> nodes) {
        super(id);
        this.name = name;
        this.nodes = this.sorted(nodes);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    public boolean isValid() {
        for (Node node : this.nodes) {
            if (node.isValid()) continue;
            return false;
        }
        return true;
    }

    public final Set<Node> nodes() {
        return Collections.unmodifiableSet(this.nodes);
    }

    public final Name name() {
        return this.name;
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean equals(Object other) {
        if (other == null || other.getClass() != Directory.class) {
            return false;
        }
        return this.nodes.equals(((Directory)other).nodes);
    }

    public int hashCode() {
        return 31 * this.nodes.hashCode();
    }

    public String toString() {
        return "Directory[" + this.id() + "," + this.name + "," + this.nodes + "]";
    }

    private Set<Node> sorted(Set<Node> nodes) {
        return new TreeSet<Node>(nodes);
    }
}

