/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.message;

import io.vlingo.cluster.model.message.ApplicationSays;
import io.vlingo.cluster.model.message.Directory;
import io.vlingo.cluster.model.message.Elect;
import io.vlingo.cluster.model.message.Join;
import io.vlingo.cluster.model.message.Leader;
import io.vlingo.cluster.model.message.Leave;
import io.vlingo.cluster.model.message.OperationalMessage;
import io.vlingo.cluster.model.message.Ping;
import io.vlingo.cluster.model.message.Pulse;
import io.vlingo.cluster.model.message.Split;
import io.vlingo.cluster.model.message.Vote;
import io.vlingo.wire.message.Converters;
import io.vlingo.wire.node.Node;
import java.nio.ByteBuffer;

public class MessageConverters {
    public static void messageToBytes(ApplicationSays app, ByteBuffer buffer) {
        String message = "APP\nid=" + app.id().value() + " nm=" + app.name().value() + " si=" + app.saysId() + "\n" + app.payload();
        byte[] bytes = Converters.textToBytes((String)message);
        buffer.put(bytes);
    }

    public static void messageToBytes(Directory dir, ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("DIR").append("\n");
        builder.append("id=").append(dir.id().value()).append(" nm=").append(dir.name().value()).append("\n");
        String lf = "";
        for (Node node : dir.nodes()) {
            builder.append(lf).append("id=").append(node.id().value()).append(" nm=").append(node.name().value()).append(" op=").append(node.operationalAddress().hostName()).append(":").append(node.operationalAddress().port()).append(" app=").append(node.applicationAddress().hostName()).append(":").append(node.applicationAddress().port());
            lf = "\n";
        }
        byte[] bytes = Converters.textToBytes((String)builder.toString());
        buffer.put(bytes);
    }

    public static void messageToBytes(Elect elect, ByteBuffer buffer) {
        MessageConverters.basicMessageToBytes(elect, "ELECT", buffer);
    }

    public static void messageToBytes(Join join, ByteBuffer buffer) {
        String message = "JOIN\nid=" + join.node().id().value() + " nm=" + join.node().name().value() + " op=" + join.node().operationalAddress().hostName() + ":" + join.node().operationalAddress().port() + " app=" + join.node().applicationAddress().hostName() + ":" + join.node().applicationAddress().port();
        byte[] bytes = Converters.textToBytes((String)message);
        buffer.put(bytes);
    }

    public static void messageToBytes(Leader leader, ByteBuffer buffer) {
        MessageConverters.basicMessageToBytes(leader, "LEADER", buffer);
    }

    public static void messageToBytes(Leave leave, ByteBuffer buffer) {
        MessageConverters.basicMessageToBytes(leave, "LEAVE", buffer);
    }

    public static void messageToBytes(Ping ping, ByteBuffer buffer) {
        MessageConverters.basicMessageToBytes(ping, "PING", buffer);
    }

    public static void messageToBytes(Pulse pulse, ByteBuffer buffer) {
        MessageConverters.basicMessageToBytes(pulse, "PULSE", buffer);
    }

    public static void messageToBytes(Split split, ByteBuffer buffer) {
        MessageConverters.basicMessageToBytes(split, "SPLIT", buffer);
    }

    public static void messageToBytes(Vote vote, ByteBuffer buffer) {
        MessageConverters.basicMessageToBytes(vote, "VOTE", buffer);
    }

    private static void basicMessageToBytes(OperationalMessage message, String type, ByteBuffer buffer) {
        String _message = type + "\nid=" + message.id().value();
        byte[] bytes = Converters.textToBytes((String)_message);
        buffer.clear();
        buffer.put(bytes);
    }
}

