/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.message;

import io.vlingo.cluster.model.message.Elect;
import io.vlingo.cluster.model.message.Join;
import io.vlingo.cluster.model.message.Leader;
import io.vlingo.cluster.model.message.Leave;
import io.vlingo.cluster.model.message.MessageConverters;
import io.vlingo.cluster.model.message.Ping;
import io.vlingo.cluster.model.message.Pulse;
import io.vlingo.cluster.model.message.Vote;
import io.vlingo.wire.message.ByteBufferAllocator;
import io.vlingo.wire.message.Converters;
import io.vlingo.wire.message.RawMessage;
import io.vlingo.wire.node.Node;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class OperationalMessageCache {
    private final Map<String, RawMessage> messages = new HashMap<String, RawMessage>();
    private final Node node;

    public OperationalMessageCache(Node node) {
        this.node = node;
        this.cacheValidTypes();
    }

    public RawMessage cachedRawMessage(String type) {
        RawMessage rawMessage = this.messages.get(type);
        if (rawMessage == null) {
            throw new IllegalArgumentException("Cache does not support type: '" + type + "'");
        }
        return rawMessage;
    }

    private void cacheValidTypes() {
        ByteBuffer buffer = ByteBufferAllocator.allocate((int)1000);
        this.cacheElect(buffer);
        this.cacheJoin(buffer);
        this.cacheLeader(buffer);
        this.cacheLeave(buffer);
        this.cachePing(buffer);
        this.cachePulse(buffer);
        this.cacheVote(buffer);
    }

    private void cacheElect(ByteBuffer buffer) {
        MessageConverters.messageToBytes(new Elect(this.node.id()), buffer);
        this.cacheMessagePair(buffer, "ELECT");
    }

    private void cacheJoin(ByteBuffer buffer) {
        MessageConverters.messageToBytes(new Join(this.node), buffer);
        this.cacheMessagePair(buffer, "JOIN");
    }

    private void cacheLeader(ByteBuffer buffer) {
        MessageConverters.messageToBytes(new Leader(this.node.id()), buffer);
        this.cacheMessagePair(buffer, "LEADER");
    }

    private void cacheLeave(ByteBuffer buffer) {
        MessageConverters.messageToBytes(new Leave(this.node.id()), buffer);
        this.cacheMessagePair(buffer, "LEAVE");
    }

    private void cachePing(ByteBuffer buffer) {
        MessageConverters.messageToBytes(new Ping(this.node.id()), buffer);
        this.cacheMessagePair(buffer, "PING");
    }

    private void cachePulse(ByteBuffer buffer) {
        MessageConverters.messageToBytes(new Pulse(this.node.id()), buffer);
        this.cacheMessagePair(buffer, "PULSE");
    }

    private void cacheVote(ByteBuffer buffer) {
        MessageConverters.messageToBytes(new Vote(this.node.id()), buffer);
        this.cacheMessagePair(buffer, "VOTE");
    }

    private void cacheMessagePair(ByteBuffer buffer, String typeKey) {
        RawMessage cachedMessage = Converters.toRawMessage((short)this.node.id().value(), (ByteBuffer)buffer);
        this.messages.put(typeKey, cachedMessage);
    }
}

