/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.node;

import io.vlingo.actors.Logger;
import io.vlingo.cluster.model.message.Directory;
import io.vlingo.cluster.model.message.Elect;
import io.vlingo.cluster.model.message.Join;
import io.vlingo.cluster.model.message.Leader;
import io.vlingo.cluster.model.message.Leave;
import io.vlingo.cluster.model.message.Vote;
import io.vlingo.cluster.model.node.LiveNodeMaintainer;
import io.vlingo.cluster.model.node.LiveNodeState;
import io.vlingo.wire.node.Node;

final class LeaderState
extends LiveNodeState {
    LeaderState(Node node, LiveNodeMaintainer liveNodeMaintainer, Logger logger) {
        super(node, liveNodeMaintainer, LiveNodeState.Type.LEADER, logger);
    }

    @Override
    protected void handle(Directory dir) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " DIRECTORY: " + dir);
        if (dir.id().greaterThan(this.node.id())) {
            this.liveNodeMaintainer.mergeAllDirectoryEntries(dir.nodes());
        } else {
            this.logger.warn("Leader must not receive Directory message from follower: '" + dir.id() + "'");
        }
    }

    @Override
    protected void handle(Elect elect) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " ELECT: " + elect);
        this.liveNodeMaintainer.voteForLocalNode(elect.id());
    }

    @Override
    protected void handle(Join join) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " JOIN: " + join);
        this.liveNodeMaintainer.join(join.node());
    }

    @Override
    protected void handle(Leader leader) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " LEADER: " + leader);
        if (leader.id().equals((Object)this.node.id())) {
            this.logger.warn("Leader must not receive Leader message of itself from a follower.");
        } else if (leader.id().greaterThan(this.node.id())) {
            this.liveNodeMaintainer.overtakeLeadership(leader.id());
        } else {
            this.liveNodeMaintainer.declareLeadership();
        }
    }

    @Override
    protected void handle(Leave leave) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " LEAVE: " + leave);
        if (leave.id().equals((Object)this.node.id())) {
            this.logger.warn("Leader must not receive Leave message of itself from a follower.");
        } else {
            this.liveNodeMaintainer.dropNode(leave.id());
        }
    }

    @Override
    protected void handle(Vote vote) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " VOTE: " + vote);
        this.liveNodeMaintainer.declareLeadership();
    }
}

