/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.node;

import io.vlingo.actors.Logger;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.message.Directory;
import io.vlingo.cluster.model.message.Elect;
import io.vlingo.cluster.model.message.Join;
import io.vlingo.cluster.model.message.Leader;
import io.vlingo.cluster.model.message.Leave;
import io.vlingo.cluster.model.message.Ping;
import io.vlingo.cluster.model.message.Pulse;
import io.vlingo.cluster.model.message.Split;
import io.vlingo.cluster.model.message.Vote;
import io.vlingo.cluster.model.node.LiveNodeMaintainer;
import io.vlingo.cluster.model.node.TimeoutTracker;
import io.vlingo.wire.node.Node;

abstract class LiveNodeState {
    final LiveNodeMaintainer liveNodeMaintainer;
    final Logger logger;
    final Node node;
    final Type type;
    final TimeoutTracker noQuorumTracker = new TimeoutTracker(Properties.instance.clusterQuorumTimeout());
    final TimeoutTracker leaderElectionTracker = new TimeoutTracker(Properties.instance.clusterHeartbeatInterval());

    public String toString() {
        return this.getClass().getSimpleName() + "[type=" + (Object)((Object)this.type) + " node=" + this.node + "]";
    }

    LiveNodeState(Node node, LiveNodeMaintainer liveNodeMaintainer, Type type, Logger logger) {
        this.node = node;
        this.liveNodeMaintainer = liveNodeMaintainer;
        this.type = type;
        this.logger = logger;
    }

    protected void handle(Directory dir) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " DIRECTORY: " + dir);
        this.liveNodeMaintainer.mergeAllDirectoryEntries(dir.nodes());
    }

    protected void handle(Elect elect) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " ELECT: " + elect);
        this.liveNodeMaintainer.escalateElection(elect.id());
    }

    protected void handle(Join join) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " JOIN: " + join);
        this.liveNodeMaintainer.joinLocalWith(join.node());
    }

    protected void handle(Leader leader) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " LEADER: " + leader);
        this.liveNodeMaintainer.assertNewLeadership(leader.id());
    }

    protected void handle(Leave leave) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " LEAVE: " + leave);
        this.liveNodeMaintainer.dropNode(leave.id());
    }

    protected void handle(Ping ping) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " PING: " + ping);
        this.liveNodeMaintainer.providePulseTo(ping.id());
    }

    protected void handle(Pulse pulse) {
        this.liveNodeMaintainer.updateLastHealthIndication(pulse.id());
    }

    protected void handle(Split split) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " SPLIT: " + split);
        this.liveNodeMaintainer.declareNodeSplit(split.id());
    }

    protected void handle(Vote vote) {
        this.logger.debug("" + (Object)((Object)this.type) + " " + this.node.id() + " VOTE: " + vote);
        this.liveNodeMaintainer.placeVote(this.node.id());
    }

    protected boolean isIdle() {
        return this.type == Type.IDLE;
    }

    protected boolean isFollower() {
        return this.type == Type.FOLLOWER;
    }

    protected boolean isLeader() {
        return this.type == Type.LEADER;
    }

    static enum Type {
        IDLE,
        FOLLOWER,
        LEADER;

    }
}

