/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.node;

import io.vlingo.actors.ActorInstantiator;
import io.vlingo.actors.Definition;
import io.vlingo.actors.Stage;
import io.vlingo.actors.Stoppable;
import io.vlingo.cluster.model.ClusterSnapshot;
import io.vlingo.cluster.model.message.OperationalMessage;
import io.vlingo.cluster.model.node.LocalLiveNodeActor;
import io.vlingo.cluster.model.node.Registry;
import io.vlingo.cluster.model.outbound.OperationalOutboundStream;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Node;
import io.vlingo.wire.node.NodeSynchronizer;

public interface LocalLiveNode
extends Stoppable {
    public static LocalLiveNode instance(Stage stage, Node node, ClusterSnapshot snapshot, Registry registry, OperationalOutboundStream outbound, Configuration configuration) {
        Definition definition = new Definition(LocalLiveNodeActor.class, (ActorInstantiator)new LocalLiveNodeInstantiator(node, snapshot, registry, outbound, configuration), "local-live-node");
        return (LocalLiveNode)stage.actorFor(LocalLiveNode.class, definition);
    }

    public void handle(OperationalMessage var1);

    public void registerNodeSynchronizer(NodeSynchronizer var1);

    public static class LocalLiveNodeInstantiator
    implements ActorInstantiator<LocalLiveNodeActor> {
        private static final long serialVersionUID = -1254550990754440942L;
        private final Node node;
        private final ClusterSnapshot snapshot;
        private final Registry registry;
        private final OperationalOutboundStream outbound;
        private final Configuration configuration;

        public LocalLiveNodeInstantiator(Node node, ClusterSnapshot snapshot, Registry registry, OperationalOutboundStream outbound, Configuration configuration) {
            this.node = node;
            this.snapshot = snapshot;
            this.registry = registry;
            this.outbound = outbound;
            this.configuration = configuration;
        }

        public LocalLiveNodeActor instantiate() {
            return new LocalLiveNodeActor(this.node, this.snapshot, this.registry, this.outbound, this.configuration);
        }

        public Class<LocalLiveNodeActor> type() {
            return LocalLiveNodeActor.class;
        }
    }
}

