/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.node;

import io.vlingo.actors.Actor;
import io.vlingo.cluster.model.ClusterSnapshot;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.message.CheckHealth;
import io.vlingo.cluster.model.message.Directory;
import io.vlingo.cluster.model.message.Elect;
import io.vlingo.cluster.model.message.Join;
import io.vlingo.cluster.model.message.Leader;
import io.vlingo.cluster.model.message.Leave;
import io.vlingo.cluster.model.message.OperationalMessage;
import io.vlingo.cluster.model.message.Ping;
import io.vlingo.cluster.model.message.Pulse;
import io.vlingo.cluster.model.message.Split;
import io.vlingo.cluster.model.message.Vote;
import io.vlingo.cluster.model.node.FollowerState;
import io.vlingo.cluster.model.node.IdleState;
import io.vlingo.cluster.model.node.LeaderState;
import io.vlingo.cluster.model.node.LiveNodeMaintainer;
import io.vlingo.cluster.model.node.LiveNodeState;
import io.vlingo.cluster.model.node.LocalLiveNode;
import io.vlingo.cluster.model.node.Registry;
import io.vlingo.cluster.model.outbound.OperationalOutboundStream;
import io.vlingo.common.Cancellable;
import io.vlingo.common.Scheduled;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Node;
import io.vlingo.wire.node.NodeSynchronizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class LocalLiveNodeActor
extends Actor
implements LocalLiveNode,
LiveNodeMaintainer,
Scheduled<Object> {
    private final Cancellable cancellable;
    private final CheckHealth checkHealth;
    private final Configuration configuration;
    private LiveNodeState state;
    private final Node node;
    private final List<NodeSynchronizer> nodeSynchronizers;
    private final OperationalOutboundStream outbound;
    private boolean quorumAchieved;
    private final LocalLiveNode selfLocalLiveNode;
    private final ClusterSnapshot snapshot;
    private final Registry registry;

    public LocalLiveNodeActor(Node node, ClusterSnapshot snapshot, Registry registry, OperationalOutboundStream outbound, Configuration configuration) {
        this.node = node;
        this.snapshot = snapshot;
        this.registry = registry;
        this.outbound = outbound;
        this.configuration = configuration;
        this.nodeSynchronizers = new ArrayList<NodeSynchronizer>();
        this.selfLocalLiveNode = (LocalLiveNode)this.selfAs(LocalLiveNode.class);
        this.checkHealth = new CheckHealth(node.id());
        this.cancellable = this.scheduleHealthCheck();
        this.declareIdle();
    }

    @Override
    public void handle(OperationalMessage message) {
        if (message.isDirectory()) {
            this.state.handle((Directory)message);
        } else if (message.isElect()) {
            this.state.handle((Elect)message);
        } else if (message.isJoin()) {
            this.state.handle((Join)message);
        } else if (message.isLeader()) {
            this.state.handle((Leader)message);
        } else if (message.isLeave()) {
            this.state.handle((Leave)message);
        } else if (message.isPing()) {
            this.state.handle((Ping)message);
        } else if (message.isPulse()) {
            this.state.handle((Pulse)message);
        } else if (message.isSplit()) {
            this.state.handle((Split)message);
        } else if (message.isVote()) {
            this.state.handle((Vote)message);
        } else if (message.isCheckHealth()) {
            this.checkHealth();
            this.informHealth();
        }
    }

    @Override
    public void registerNodeSynchronizer(NodeSynchronizer nodeSynchronizer) {
        this.nodeSynchronizers.add(nodeSynchronizer);
    }

    @Override
    public void assertNewLeadership(Id assertingNodeId) {
        Node currentLeader = this.registry.currentLeader();
        if (currentLeader.isLeaderOver(assertingNodeId)) {
            this.outbound.split(assertingNodeId, currentLeader.id());
        } else {
            this.declareFollower();
            this.promoteElectedLeader(assertingNodeId);
        }
    }

    @Override
    public void declareLeadership() {
        this.outbound.directory(new TreeSet<Node>(this.registry.liveNodes()));
        this.outbound.leader();
    }

    @Override
    public void escalateElection(Id electId) {
        this.registry.join(this.node);
        this.registry.join(this.configuration.nodeMatching(electId));
        if (this.node.id().greaterThan(electId)) {
            if (this.state.leaderElectionTracker.hasNotStarted()) {
                this.state.leaderElectionTracker.start(true);
                this.outbound.elect(this.configuration.allGreaterNodes(this.node.id()));
            } else if (this.state.leaderElectionTracker.hasTimedOut()) {
                this.declareLeadership();
                return;
            }
            this.outbound.vote(electId);
        }
    }

    @Override
    public void declareNodeSplit(Id leaderNodeId) {
        this.declareFollower();
        this.promoteElectedLeader(leaderNodeId);
    }

    @Override
    public void dropNode(Id id) {
        boolean droppedLeader = this.registry.isLeader(id);
        this.dropNodeFromCluster(id);
        if (droppedLeader) {
            this.state.leaderElectionTracker.start(true);
            this.outbound.elect(this.configuration.allGreaterNodes(this.node.id()));
        }
        if (this.state.isLeader()) {
            this.declareLeadership();
        }
    }

    @Override
    public void join(Node joiningNode) {
        this.registry.join(joiningNode);
        this.outbound.open(joiningNode.id());
        if (this.state.isLeader()) {
            this.declareLeadership();
        }
        this.synchronize(joiningNode);
    }

    @Override
    public void joinLocalWith(Node remoteNode) {
        this.join(this.node);
        this.join(remoteNode);
    }

    @Override
    public void mergeAllDirectoryEntries(Set<Node> nodes) {
        this.registry.mergeAllDirectoryEntries(nodes);
    }

    @Override
    public void overtakeLeadership(Id leaderNodeId) {
        this.declareFollower();
    }

    @Override
    public void placeVote(Id voterId) {
        if (this.node.id().greaterThan(voterId)) {
            this.outbound.vote(voterId);
        } else {
            this.state.leaderElectionTracker.clear();
        }
    }

    @Override
    public void providePulseTo(Id id) {
        this.outbound.pulse(id);
    }

    public void synchronize(Node node) {
        for (NodeSynchronizer syncher : this.nodeSynchronizers) {
            syncher.synchronize(node);
        }
    }

    @Override
    public void updateLastHealthIndication(Id id) {
        this.registry.updateLastHealthIndication(id);
    }

    @Override
    public void voteForLocalNode(Id targetNodeId) {
        this.outbound.vote(targetNodeId);
        this.declareLeadership();
    }

    public void intervalSignal(Scheduled<Object> scheduled, Object data) {
        this.registry.cleanTimedOutNodes();
        this.selfLocalLiveNode.handle(this.checkHealth);
    }

    public void stop() {
        this.outbound.leave();
        this.cancellable.cancel();
        this.registry.leave(this.node.id());
        super.stop();
    }

    private void checkHealth() {
        if (this.registry.hasQuorum()) {
            this.maintainHealthWithQuorum();
        } else {
            this.maintainHealthWithNoQuorum();
        }
    }

    private void declareFollower() {
        if (this.state == null || !this.state.isFollower()) {
            this.logger().info("Cluster follower: " + this.node);
            this.state = new FollowerState(this.node, this, this.logger());
        }
    }

    private void declareIdle() {
        if (this.state == null || !this.state.isIdle()) {
            this.logger().info("Cluster idle: " + this.node);
            this.state = new IdleState(this.node, this, this.logger());
            if (this.registry.currentLeader().equals((Object)this.node)) {
                this.registry.demoteLeaderOf(this.node.id());
            }
        }
    }

    private void declareLeader() {
        this.logger().info("Cluster leader: " + this.node);
        this.state = new LeaderState(this.node, this, this.logger());
        this.promoteElectedLeader(this.node.id());
        this.outbound.directory(this.registry.liveNodes());
        this.outbound.leader();
    }

    private void dropNodeFromCluster(Id nodeId) {
        if (this.registry.hasMember(nodeId)) {
            this.registry.leave(nodeId);
            this.outbound.close(nodeId);
        }
    }

    private void informHealth() {
        this.outbound.pulse();
        if (this.registry.hasMember(this.node.id())) {
            this.registry.updateLastHealthIndication(this.node.id());
        }
        if (this.state.isIdle() || !this.registry.isConfirmedByLeader(this.node.id())) {
            this.outbound.join();
        }
    }

    private void maintainHealthWithNoQuorum() {
        this.state.leaderElectionTracker.reset();
        this.state.noQuorumTracker.start();
        this.watchForQuorumRelinquished();
        if (this.state.noQuorumTracker.hasTimedOut()) {
            this.logger().warn("No quorum; leaving cluster to become idle node.");
            this.registry.leave(this.node.id());
            this.declareIdle();
        }
    }

    private void maintainHealthWithQuorum() {
        this.state.noQuorumTracker.reset();
        this.watchForQuorumAchievement();
        if (!this.registry.hasLeader()) {
            if (this.state.leaderElectionTracker.hasNotStarted()) {
                this.state.leaderElectionTracker.start();
                this.outbound.elect(this.configuration.allGreaterNodes(this.node.id()));
            } else if (this.state.leaderElectionTracker.hasTimedOut()) {
                this.declareLeader();
            }
        }
    }

    private void promoteElectedLeader(Id leaderNodeId) {
        if (this.node.id().equals((Object)leaderNodeId)) {
            this.registry.join(this.node);
            this.registry.declareLeaderAs(leaderNodeId);
            this.registry.confirmAllLiveNodesByLeader();
        } else {
            if (this.registry.isLeader(this.node.id())) {
                this.registry.demoteLeaderOf(this.node.id());
            }
            if (!this.registry.hasMember(leaderNodeId)) {
                this.registry.join(this.configuration.nodeMatching(leaderNodeId));
            }
            this.registry.declareLeaderAs(leaderNodeId);
        }
    }

    private Cancellable scheduleHealthCheck() {
        return this.stage().scheduler().schedule((Scheduled)this.selfAs(Scheduled.class), null, 1000L, Properties.instance.clusterHealthCheckInterval());
    }

    private void watchForQuorumAchievement() {
        if (!this.quorumAchieved) {
            this.quorumAchieved = true;
            this.snapshot.quorumAchieved();
        }
    }

    private void watchForQuorumRelinquished() {
        if (this.quorumAchieved) {
            this.quorumAchieved = false;
            this.snapshot.quorumLost();
        }
    }
}

