/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.node;

import io.vlingo.actors.Logger;
import io.vlingo.cluster.model.Properties;
import io.vlingo.cluster.model.node.MergeResult;
import io.vlingo.cluster.model.node.RegisteredNodeStatus;
import io.vlingo.cluster.model.node.Registry;
import io.vlingo.cluster.model.node.RegistryInterest;
import io.vlingo.cluster.model.node.RegistryInterestBroadcaster;
import io.vlingo.wire.node.Configuration;
import io.vlingo.wire.node.Id;
import io.vlingo.wire.node.Node;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class LocalRegistry
implements Registry {
    private final RegistryInterestBroadcaster broadcaster;
    private final Configuration configuration;
    private final Node localNode;
    private final Logger logger;
    private Map<Id, RegisteredNodeStatus> registry;

    public LocalRegistry(Node localNode, Configuration confirguration, Logger logger) {
        this.localNode = localNode;
        this.configuration = confirguration;
        this.logger = logger;
        this.broadcaster = new RegistryInterestBroadcaster(logger);
        this.registry = new TreeMap<Id, RegisteredNodeStatus>();
    }

    @Override
    public void cleanTimedOutNodes() {
        long currentTime = System.currentTimeMillis();
        long liveNodeTimeout = Properties.instance.clusterLiveNodeTimeout();
        TreeMap<Id, RegisteredNodeStatus> nodesToKeep = new TreeMap<Id, RegisteredNodeStatus>();
        for (RegisteredNodeStatus status : this.registry.values()) {
            if (!status.isTimedOut(currentTime, liveNodeTimeout)) {
                nodesToKeep.put(status.node().id(), status);
                continue;
            }
            this.demoteLeaderOf(status.node().id());
            this.broadcaster.informNodeTimedOut(status.node(), this.isClusterHealthy());
            this.logger.info("Node cleaned from registry due to timeout: " + status.node());
        }
        this.registry = nodesToKeep;
    }

    @Override
    public void confirmAllLiveNodesByLeader() {
        for (RegisteredNodeStatus status : this.registry.values()) {
            status.confirmedByLeader(true);
            this.broadcaster.informConfirmedByLeader(status.node(), this.isClusterHealthy());
        }
    }

    @Override
    public boolean isConfirmedByLeader(Id id) {
        RegisteredNodeStatus status = this.registry.get(id);
        if (status != null) {
            return status.isConfirmedByLeader();
        }
        return false;
    }

    @Override
    public Node currentLeader() {
        for (RegisteredNodeStatus status : this.registry.values()) {
            if (!status.isLeader()) continue;
            return status.node();
        }
        return Node.NO_NODE;
    }

    @Override
    public void declareLeaderAs(Id id) {
        RegisteredNodeStatus status = this.registry.get(id);
        if (status != null) {
            status.lead(true);
            status.updateLastHealthIndication();
            this.broadcaster.informCurrentLeader(status.node(), this.isClusterHealthy());
            this.demotePreviousLeader(id);
        } else {
            this.logger.warn("Cannot declare leader because missing node: '" + id + "'");
        }
    }

    @Override
    public void demoteLeaderOf(Id id) {
        RegisteredNodeStatus status = this.registry.get(id);
        if (status != null && status.isLeader()) {
            status.lead(false);
            this.broadcaster.informLeaderDemoted(status.node(), this.isClusterHealthy());
        }
    }

    @Override
    public boolean isLeader(Id id) {
        RegisteredNodeStatus status = this.registry.get(id);
        if (status != null) {
            return status.isLeader();
        }
        return false;
    }

    @Override
    public boolean hasLeader() {
        for (RegisteredNodeStatus status : this.registry.values()) {
            if (!status.isLeader()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Node> liveNodes() {
        TreeSet<Node> liveNodes = new TreeSet<Node>();
        for (RegisteredNodeStatus status : this.registry.values()) {
            liveNodes.add(status.node());
        }
        return liveNodes;
    }

    @Override
    public boolean hasMember(Id id) {
        return this.registry.containsKey(id);
    }

    @Override
    public boolean hasQuorum() {
        int quorum = this.configuration.totalNodes() / 2 + 1;
        return this.liveNodes().size() >= quorum;
    }

    @Override
    public void join(Node node) {
        if (!this.hasMember(node.id())) {
            this.registry.put(node.id(), new RegisteredNodeStatus(node, false, false));
            this.broadcaster.informNodeJoinedCluster(node, this.isClusterHealthy());
            this.broadcaster.informAllLiveNodes(this.liveNodes(), this.isClusterHealthy());
        }
    }

    @Override
    public void leave(Id id) {
        RegisteredNodeStatus status = this.registry.remove(id);
        if (status != null) {
            this.demoteLeaderOf(id);
            this.broadcaster.informNodeLeftCluster(status.node(), this.isClusterHealthy());
            this.broadcaster.informAllLiveNodes(this.liveNodes(), this.isClusterHealthy());
        } else {
            this.logger.warn("Cannot leave because missing node: '" + id + "'");
        }
    }

    @Override
    public void mergeAllDirectoryEntries(Collection<Node> leaderRegisteredNodes) {
        TreeSet<MergeResult> result = new TreeSet<MergeResult>();
        TreeMap<Id, RegisteredNodeStatus> mergedNodes = new TreeMap<Id, RegisteredNodeStatus>();
        for (Node node : leaderRegisteredNodes) {
            mergedNodes.put(node.id(), new RegisteredNodeStatus(node, this.isLeader(node.id()), true));
        }
        for (RegisteredNodeStatus status : mergedNodes.values()) {
            if (this.registry.containsKey(status.node().id())) continue;
            result.add(new MergeResult(status.node(), true));
        }
        for (RegisteredNodeStatus status : this.registry.values()) {
            if (mergedNodes.containsKey(status.node().id())) continue;
            this.demoteLeaderOf(status.node().id());
            result.add(new MergeResult(status.node(), false));
        }
        this.registry = mergedNodes;
        this.broadcaster.informMergedAllDirectoryEntries(this.liveNodes(), result, this.isClusterHealthy());
        this.broadcaster.informAllLiveNodes(this.liveNodes(), this.isClusterHealthy());
    }

    @Override
    public void promoteElectedLeader(Id leaderNodeId) {
        if (this.localNode.id().equals((Object)leaderNodeId)) {
            this.declareLeaderAs(leaderNodeId);
            this.confirmAllLiveNodesByLeader();
        } else {
            if (this.isLeader(this.localNode.id())) {
                this.demoteLeaderOf(this.localNode.id());
            }
            if (!this.hasMember(leaderNodeId)) {
                this.join(this.configuration.nodeMatching(leaderNodeId));
            }
            this.declareLeaderAs(leaderNodeId);
        }
        this.broadcaster.informCurrentLeader(this.registry.get(leaderNodeId).node(), this.isClusterHealthy());
    }

    @Override
    public void registerRegistryInterest(RegistryInterest interest) {
        this.broadcaster.registerRegistryInterest(interest);
    }

    @Override
    public void updateLastHealthIndication(Id id) {
        RegisteredNodeStatus status = this.registry.get(id);
        if (status != null) {
            status.updateLastHealthIndication();
            this.broadcaster.informNodeIsHealthy(status.node(), this.isClusterHealthy());
        }
    }

    RegisteredNodeStatus registeredNodeStatusOf(Id id) {
        return this.registry.get(id);
    }

    private boolean isClusterHealthy() {
        return this.hasQuorum() && this.hasLeader();
    }

    private void demotePreviousLeader(Id currentLeaderNodeId) {
        for (RegisteredNodeStatus status : this.registry.values()) {
            if (status.node().id().equals((Object)currentLeaderNodeId) || !status.isLeader()) continue;
            status.lead(false);
            this.broadcaster.informLeaderDemoted(status.node(), this.isClusterHealthy());
        }
    }
}

