/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.node;

import io.vlingo.wire.node.Node;

public class RegisteredNodeStatus {
    private boolean confirmedByLeader;
    private long lastHealthIndication;
    private boolean leader;
    private final Node node;

    public void confirmedByLeader(boolean isConfirmed) {
        this.confirmedByLeader = isConfirmed;
    }

    public boolean isConfirmedByLeader() {
        return this.confirmedByLeader;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public boolean isTimedOut(long currentTime, long liveNodeTimeout) {
        long timeOutTime = this.lastHealthIndication() + liveNodeTimeout;
        return timeOutTime < currentTime;
    }

    public long lastHealthIndication() {
        return this.lastHealthIndication;
    }

    public void lead(boolean lead) {
        this.leader = lead;
    }

    public Node node() {
        return this.node;
    }

    public void updateLastHealthIndication() {
        this.lastHealthIndication = System.currentTimeMillis();
    }

    RegisteredNodeStatus(Node node, boolean isLeader, boolean confirmedByLeader) {
        this.node = node;
        this.leader = isLeader;
        this.lastHealthIndication = System.currentTimeMillis();
        this.confirmedByLeader = confirmedByLeader;
    }

    void setLastHealthIndication(long millis) {
        this.lastHealthIndication = millis;
    }
}

