/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.node;

import io.vlingo.actors.Logger;
import io.vlingo.cluster.model.node.MergeResult;
import io.vlingo.cluster.model.node.RegistryInterest;
import io.vlingo.wire.node.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public class RegistryInterestBroadcaster
implements RegistryInterest {
    private final Logger logger;
    private final List<RegistryInterest> registryInterests;

    RegistryInterestBroadcaster(Logger logger) {
        this.logger = logger;
        this.registryInterests = new ArrayList<RegistryInterest>();
    }

    public void registerRegistryInterest(RegistryInterest interest) {
        this.registryInterests.add(interest);
    }

    @Override
    public void informAllLiveNodes(Collection<Node> liveNodes, boolean isHealthyCluster) {
        this.broadcast(interest -> interest.informAllLiveNodes(liveNodes, isHealthyCluster));
    }

    @Override
    public void informConfirmedByLeader(Node node, boolean isHealthyCluster) {
        this.broadcast(interest -> interest.informConfirmedByLeader(node, isHealthyCluster));
    }

    @Override
    public void informCurrentLeader(Node node, boolean isHealthyCluster) {
        this.broadcast(interest -> interest.informCurrentLeader(node, isHealthyCluster));
    }

    @Override
    public void informMergedAllDirectoryEntries(Collection<Node> liveNodes, Collection<MergeResult> mergeResults, boolean isHealthyCluster) {
        this.broadcast(interest -> interest.informMergedAllDirectoryEntries(liveNodes, mergeResults, isHealthyCluster));
    }

    @Override
    public void informLeaderDemoted(Node node, boolean isHealthyCluster) {
        this.broadcast(interest -> interest.informLeaderDemoted(node, isHealthyCluster));
    }

    @Override
    public void informNodeIsHealthy(Node node, boolean isHealthyCluster) {
        this.broadcast(interest -> interest.informNodeIsHealthy(node, isHealthyCluster));
    }

    @Override
    public void informNodeJoinedCluster(Node node, boolean isHealthyCluster) {
        this.broadcast(interest -> interest.informNodeJoinedCluster(node, isHealthyCluster));
    }

    @Override
    public void informNodeLeftCluster(Node node, boolean isHealthyCluster) {
        this.broadcast(interest -> interest.informNodeLeftCluster(node, isHealthyCluster));
    }

    @Override
    public void informNodeTimedOut(Node node, boolean isHealthyCluster) {
        this.broadcast(interest -> interest.informNodeTimedOut(node, isHealthyCluster));
    }

    private void broadcast(Consumer<RegistryInterest> inform) {
        for (RegistryInterest interest : this.registryInterests) {
            try {
                inform.accept(interest);
            }
            catch (Exception e) {
                this.logger.error("Cannot inform because: " + e.getMessage(), (Throwable)e);
            }
        }
    }
}

