/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.cluster.model.node;

final class TimeoutTracker {
    private boolean cleared = false;
    private long startTime = -1L;
    private final long timeout;

    TimeoutTracker(long timeout) {
        this.timeout = timeout;
    }

    void clear() {
        this.cleared = true;
        this.reset();
    }

    boolean hasTimedOut() {
        if (!this.cleared && this.startTime > 0L) {
            long currentTime = System.currentTimeMillis();
            return currentTime >= this.startTime + this.timeout;
        }
        return false;
    }

    void reset() {
        this.startTime = -1L;
    }

    boolean hasNotStarted() {
        return this.startTime <= 0L;
    }

    void start() {
        this.start(false);
    }

    void start(boolean force) {
        if (force && this.startTime == -1L || !this.cleared && this.startTime == -1L) {
            this.cleared = false;
            this.startTime = System.currentTimeMillis();
        }
    }
}

