/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common;

import io.vlingo.common.Cancellable;
import io.vlingo.common.Completes;
import io.vlingo.common.Scheduled;
import io.vlingo.common.Scheduler;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;

public class BasicCompletes<T>
implements Completes<T> {
    private static boolean DEBUG = false;
    protected final ActiveState<T> state;

    public BasicCompletes(Scheduler scheduler) {
        this(new BasicActiveState(scheduler), true);
    }

    public BasicCompletes(Scheduler scheduler, ActiveState<T> parent) {
        this(new BasicActiveState<T>(scheduler, parent), true);
    }

    public BasicCompletes(T outcome, boolean succeeded) {
        this(new BasicActiveState(), outcome, succeeded);
    }

    public BasicCompletes(T outcome) {
        this(new BasicActiveState(), outcome);
    }

    protected BasicCompletes(ActiveState<T> state) {
        this.state = state;
    }

    protected BasicCompletes(ActiveState<T> state, T outcome, boolean succeeded) {
        this.state = state;
        if (succeeded) {
            this.state.completedWith(outcome);
        } else {
            this.state.failedValue(outcome);
            this.state.failed();
        }
    }

    protected BasicCompletes(ActiveState<T> state, T outcome) {
        this.state = state;
        this.state.outcome(outcome);
    }

    @Override
    public <O> Completes<O> andThen(long timeout, O failedOutcomeValue, Function<T, O> function) {
        BasicCompletes.debug("AT3-TO-FO-FN: " + this.state.id() + ": " + failedOutcomeValue);
        this.state.failedValue(failedOutcomeValue);
        this.state.registerWithExecution(Action.with(function), timeout, this.state);
        return this;
    }

    @Override
    public <O> Completes<O> andThen(O failedOutcomeValue, Function<T, O> function) {
        BasicCompletes.debug("AT2-FO-FN: " + this.state.id() + ": " + failedOutcomeValue);
        return this.andThen(-1L, failedOutcomeValue, function);
    }

    @Override
    public <O> Completes<O> andThen(long timeout, Function<T, O> function) {
        BasicCompletes.debug("AT2-TO-FN: " + this.state.id());
        return this.andThen(timeout, null, function);
    }

    @Override
    public <O> Completes<O> andThen(Function<T, O> function) {
        BasicCompletes.debug("AT1-FN: " + this.state.id());
        return this.andThen(-1L, null, function);
    }

    @Override
    public Completes<T> andThenConsume(long timeout, T failedOutcomeValue, Consumer<T> consumer) {
        this.state.failedValue(failedOutcomeValue);
        this.state.registerWithExecution(Action.with(consumer), timeout, this.state);
        return this;
    }

    @Override
    public Completes<T> andThenConsume(long timeout, Consumer<T> consumer) {
        return this.andThenConsume(timeout, null, consumer);
    }

    @Override
    public Completes<T> andThenConsume(T failedOutcomeValue, Consumer<T> consumer) {
        return this.andThenConsume(-1L, failedOutcomeValue, consumer);
    }

    @Override
    public Completes<T> andThenConsume(Consumer<T> consumer) {
        return this.andThenConsume(-1L, null, consumer);
    }

    @Override
    public <F, O> O andThenTo(long timeout, F failedOutcomeValue, Function<T, O> function) {
        BasicCompletes.debug("ATT FV3: " + this.state.id() + ": " + failedOutcomeValue);
        BasicCompletes.debug("ATT FV3 NESTING: " + this.state.id());
        BasicCompletes<T> nestedCompletes = new BasicCompletes<T>((BasicActiveState)this.state, false);
        nestedCompletes.state.failedValue(failedOutcomeValue);
        this.state.registerWithExecution(Action.with(function, nestedCompletes), timeout, this.state);
        return (O)nestedCompletes;
    }

    @Override
    public <F, O> O andThenTo(F failedOutcomeValue, Function<T, O> function) {
        BasicCompletes.debug("ATT2-FO-FN FV2: " + this.state.id() + ": " + failedOutcomeValue);
        return this.andThenTo(-1L, failedOutcomeValue, function);
    }

    @Override
    public <O> O andThenTo(long timeout, Function<T, O> function) {
        BasicCompletes.debug("ATT2-TO-FN FV: " + this.state.id());
        return this.andThenTo(timeout, BasicActiveState.UnfailedValue, function);
    }

    @Override
    public <O> O andThenTo(Function<T, O> function) {
        BasicCompletes.debug("ATT1-FN: " + this.state.id());
        return this.andThenTo(-1L, BasicActiveState.UnfailedValue, function);
    }

    @Override
    public <E> Completes<T> otherwise(Function<E, T> function) {
        BasicCompletes.debug("OW-FN: " + this.state.id() + ": " + BasicCompletes.printLimitedTrace(7));
        this.state.failureAction(Action.with(function));
        return this;
    }

    @Override
    public Completes<T> otherwiseConsume(Consumer<T> consumer) {
        this.state.failureAction(Action.with(consumer));
        return this;
    }

    @Override
    public Completes<T> recoverFrom(Function<Exception, T> function) {
        this.state.exceptionAction(function);
        return this;
    }

    @Override
    public <O> O await() {
        this.state.await();
        return (O)this.outcome();
    }

    @Override
    public <O> O await(long timeout) {
        if (this.state.await(timeout)) {
            return (O)this.outcome();
        }
        return null;
    }

    @Override
    public boolean isCompleted() {
        return this.state.isOutcomeKnown();
    }

    @Override
    public boolean hasFailed() {
        return this.state.hasFailed();
    }

    @Override
    public void failed() {
        this.with(this.state.failedValue());
    }

    @Override
    public void failed(Exception exception) {
        this.state.handleException(exception);
    }

    @Override
    public boolean hasOutcome() {
        return this.state.hasOutcome();
    }

    @Override
    public T outcome() {
        return (T)this.state.outcome();
    }

    @Override
    public Completes<T> repeat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Completes<T> timeoutWithin(long timeout) {
        this.state.startTimer(timeout);
        return this;
    }

    @Override
    public <F> Completes<T> useFailedOutcomeOf(F failedOutcomeValue) {
        this.state.failedValue(failedOutcomeValue);
        return this;
    }

    @Override
    public <O> Completes<O> with(O outcome) {
        if (!this.state.handleFailure(outcome)) {
            BasicCompletes.debug("SUCCEESS WITH: " + this.state.id() + " :" + outcome);
            this.state.completedWith(outcome);
        } else {
            BasicCompletes.debug("FAILED WITH: " + outcome);
        }
        return this;
    }

    @Override
    public <O> Completes<O> andFinally() {
        return this.andFinally(value -> value);
    }

    @Override
    public <O> Completes<O> andFinally(Function<T, O> function) {
        return this.andThen(function);
    }

    @Override
    public void andFinallyConsume(Consumer<T> consumer) {
        this.andThenConsume(consumer);
    }

    private BasicCompletes(BasicActiveState<T> parent, boolean root) {
        this.state = root ? parent : new BasicActiveState<T>(parent.scheduler(), parent);
    }

    private static void debug(String message) {
        if (DEBUG) {
            System.out.println(message);
        }
    }

    private static String printLimitedTrace(int levels) {
        if (DEBUG) {
            StackTraceElement[] trace;
            int idx;
            StringBuilder builder = new StringBuilder();
            int max = Math.min(levels + idx, trace.length);
            int count = 1;
            for (idx = (trace = new Exception().getStackTrace())[1].toString().contains("BasicCompletes.access$") ? 2 : 1; idx < max; ++idx) {
                builder.append("\n").append("TRACE: ").append(count++).append(": ").append(trace[idx]);
            }
            return builder.toString();
        }
        return "";
    }

    protected static class BasicActiveState<T>
    implements ActiveState<T>,
    Scheduled<Object> {
        private static final Object UnfailedValue = new Object();
        private Cancellable cancellable;
        private ActiveState<T> child;
        private final Executables<T> executables;
        private final AtomicBoolean failed;
        private AtomicReference<T> failedOutcomeValue;
        private final List<Action<T>> failureActions;
        private AtomicReference<Exception> exception;
        private Function<Exception, ?> exceptionAction;
        private final AtomicReference<Object> outcome;
        private CountDownLatch outcomeKnown;
        private final ActiveState<T> parent;
        private Scheduler scheduler;
        private final AtomicBoolean timedOut;
        static final AtomicInteger nextId = new AtomicInteger(0);
        final String id;
        int nextChildId = 1;

        protected BasicActiveState(Scheduler scheduler, ActiveState<T> parent) {
            this.scheduler = scheduler;
            this.parent = parent;
            this.executables = new Executables();
            this.failed = this.isFailed(parent);
            this.failedOutcomeValue = this.failedValueOf(parent);
            this.failureActions = this.failureActions(parent);
            this.exception = new AtomicReference<Object>(null);
            this.exceptionAction = e -> null;
            this.outcome = new AtomicReference<Object>(null);
            this.outcomeKnown = new CountDownLatch(1);
            this.timedOut = new AtomicBoolean(false);
            this.id = this.id(parent);
            if (parent != null) {
                parent.child(this);
            }
            BasicCompletes.debug("BAS NEW: " + this.id() + ": " + BasicCompletes.printLimitedTrace(10));
        }

        private List<Action<T>> failureActions(ActiveState<T> parent) {
            if (parent != null) {
                return new CopyOnWriteArrayList<Action<T>>(parent.failureActions());
            }
            return new CopyOnWriteArrayList<Action<T>>();
        }

        private AtomicReference<T> failedValueOf(ActiveState<T> parent) {
            if (parent != null && parent.hasFailed()) {
                new AtomicReference<T>(parent.failedValue());
            }
            return new AtomicReference<Object>(UnfailedValue);
        }

        private AtomicBoolean isFailed(ActiveState<T> parent) {
            if (parent != null && parent.hasFailed()) {
                return new AtomicBoolean(true);
            }
            return new AtomicBoolean(false);
        }

        @Override
        public String id() {
            return this.id;
        }

        private String id(ActiveState<T> parent) {
            if (parent != null) {
                BasicActiveState bs = (BasicActiveState)parent;
                int childId = bs.nextChildId++;
                return bs.id + "." + childId;
            }
            return "" + nextId.incrementAndGet();
        }

        protected BasicActiveState(Scheduler scheduler) {
            this(scheduler, null);
        }

        protected BasicActiveState() {
            this(null);
        }

        @Override
        public void await() {
            try {
                this.outcomeKnown.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public boolean await(long timeout) {
            try {
                return this.outcomeKnown.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        @Override
        public void backUp(Action<T> action) {
        }

        @Override
        public void cancelTimer() {
            if (this.cancellable != null) {
                this.cancellable.cancel();
                this.cancellable = null;
            }
        }

        @Override
        public ActiveState<T> child() {
            return this.child;
        }

        @Override
        public void child(ActiveState<T> child) {
            this.child = child;
        }

        @Override
        public boolean hasChild() {
            return this.child != null;
        }

        @Override
        public void completedWith(T outcome) {
            this.cancelTimer();
            if (!this.timedOut.get()) {
                this.outcome.set(outcome);
            }
            this.executables.execute(this);
            this.outcomeKnown(true);
        }

        @Override
        public boolean executeFailureAction() {
            boolean executed = false;
            BasicCompletes.debug("EXEC-FA-1: " + this.id() + ": " + BasicCompletes.printLimitedTrace(10));
            int idx = 0;
            while (idx < this.failureActions.size()) {
                Action<T> failureAction;
                if ((failureAction = this.failureActions.get(idx++)) == null) continue;
                BasicCompletes.debug("EXEC-FA-1.1: " + this.id);
                Action<T> executeFailureAction = failureAction;
                this.failed.set(true);
                try {
                    if (executeFailureAction.isConsumer()) {
                        BasicCompletes.debug("EXEC-FA-C1.1.1-BEGIN: " + this.id);
                        executeFailureAction.asConsumer().accept(this.outcome.get());
                        BasicCompletes.debug("EXEC-FA-C1.1.1-END: " + this.id);
                    } else {
                        BasicCompletes.debug("EXEC-FA-F1.1.2-BEGIN: " + this.id);
                        this.outcome.set(executeFailureAction.asFunction().apply(this.outcome.get()));
                        BasicCompletes.debug("EXEC-FA-F1.1.2-END: " + this.id);
                    }
                    executed = true;
                }
                catch (Throwable t) {
                    BasicCompletes.debug("EXEC-FA-F1.1.3-EXECEPTION: " + this.id + ": CONTINUING");
                }
            }
            if (!executed && this.child != null) {
                BasicCompletes.debug("EXEC-FA-1.2.1: DELEGATE TO CHILD: " + this.id);
                Object failedOutcome = this.outcome.get();
                this.child.failedValue(failedOutcome);
                if (this.child.handleFailure(failedOutcome)) {
                    BasicCompletes.debug("EXEC-FA-1.2.2: CHILD HANDLED FOR: " + this.id);
                    return true;
                }
            }
            BasicCompletes.debug("EFA-1.3: " + this.id + ": ACTION: " + executed);
            return executed;
        }

        @Override
        public boolean isExecutable() {
            BasicCompletes.debug("EXECUTABLE: " + this.id + ": " + this.executables.wasExecutable());
            return ((Executables)this.executables).hasAction() || this.executables.wasExecutable();
        }

        @Override
        public boolean hasFailed() {
            return this.failed.get();
        }

        @Override
        public void failed() {
            this.handleFailure(this.failedOutcomeValue.get());
        }

        @Override
        public <F> void failedValue(F failedOutcomeValue) {
            T failureValue = this.failedOutcomeValue.get();
            if (failedOutcomeValue == null && failureValue != null && failureValue != UnfailedValue) {
                BasicCompletes.debug("FAILED VALUE: NOT SETTING: " + this.id + ": " + failedOutcomeValue);
                return;
            }
            this.failedOutcomeValue.set(failedOutcomeValue);
        }

        @Override
        public T failedValue() {
            return this.failedOutcomeValue.get();
        }

        @Override
        public void failureAction(Action<T> action) {
            BasicCompletes.debug("FAILURE ACTION: " + this.id() + (action == null ? ": NULL" : ": FN()") + ": " + BasicCompletes.printLimitedTrace(10));
            this.failureActions.add(action);
            BasicCompletes.debug("FAILURE-ACTION REGISTERED: " + this.id + ": TO: " + action + ": TOTAL: " + this.failureActions.size());
            if (this.isOutcomeKnown() && this.hasFailed()) {
                BasicCompletes.debug("FAILURE-ACTION EXECUTING: " + this.id);
                this.executeFailureAction();
            } else {
                BasicCompletes.debug("FAILURE-ACTION: " + this.id + ": NOT EXECUTING: OUTCOME? " + this.isOutcomeKnown() + " FAILED? " + this.hasFailed());
            }
        }

        @Override
        public List<Action<T>> failureActions() {
            return this.failureActions;
        }

        @Override
        public void failureActions(List<Action<T>> actions) {
            this.failureActions.addAll(actions);
        }

        @Override
        public boolean handleFailure(T outcome) {
            if (this.isOutcomeKnown() && this.hasFailed()) {
                BasicCompletes.debug("FV-ALREADY: " + this.id() + ": " + BasicCompletes.printLimitedTrace(10));
                return true;
            }
            T tempFailureOutcomeValue = this.failedOutcomeValue.get();
            BasicCompletes.debug("FV: " + this.id + " FV: (" + tempFailureOutcomeValue + ") O: (" + outcome + ") FVSTD: " + BasicActiveState.UnfailedValue + BasicCompletes.printLimitedTrace(10));
            boolean handle = false;
            if (outcome == tempFailureOutcomeValue) {
                BasicCompletes.debug("FV==: " + this.id);
                handle = true;
            } else if (outcome != null && tempFailureOutcomeValue != null && tempFailureOutcomeValue.equals(outcome)) {
                BasicCompletes.debug("FVEQ: " + this.id);
                handle = true;
            }
            if (handle) {
                this.failed.set(true);
                this.executables.reset();
                this.outcome.set(tempFailureOutcomeValue);
                this.outcomeKnown(true);
                this.executeFailureAction();
            } else if (this.hasChild()) {
                return this.child().handleFailure(outcome);
            }
            return handle;
        }

        @Override
        public void exceptionAction(Function<Exception, T> function) {
            this.exceptionAction = function;
            this.handleException();
        }

        @Override
        public void handleException() {
            if (this.hasException()) {
                this.handleException(this.exception.get());
            }
        }

        @Override
        public void handleException(Exception e) {
            this.exception.set(e);
            if (this.exceptionAction != null) {
                this.failed.set(true);
                this.executables.reset();
                this.outcome.set(this.exceptionAction.apply(e));
                this.outcomeKnown(true);
            } else if (this.parent != null) {
                this.parent.handleException(e);
            } else {
                BasicCompletes.debug("[WARN] Exception doesn't have (yet?) appropriate exceptionAction specified! Exception type: " + e.getClass().getName() + ". Exception message: " + e.getMessage() + ". Exception thrown from: " + e.getStackTrace()[0].toString());
            }
        }

        @Override
        public boolean hasException() {
            return this.exception.get() != null;
        }

        @Override
        public boolean hasOutcome() {
            return this.outcome.get() != null;
        }

        @Override
        public void outcome(T outcome) {
            this.outcome.set(outcome);
        }

        @Override
        public <O> O outcome() {
            return (O)this.outcome.get();
        }

        @Override
        public boolean isOutcomeKnown() {
            return this.outcomeKnown.getCount() == 0L;
        }

        @Override
        public void outcomeKnown(boolean flag) {
            if (flag) {
                this.outcomeKnown.countDown();
            } else {
                this.outcomeKnown = new CountDownLatch(1);
            }
        }

        @Override
        public boolean outcomeMustDefault() {
            return this.outcome() == null;
        }

        @Override
        public void registerWithExecution(Action<T> action, long timeout, ActiveState<T> state) {
            this.executables.registerWithExecution(action, timeout, state);
        }

        @Override
        public boolean isRepeatable() {
            return false;
        }

        @Override
        public void repeat() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <F> boolean replaceFailedOutcomeValue(F failedOutcomeValue) {
            if (this.failedValue() == UnfailedValue) {
                this.failedValue(failedOutcomeValue);
                return true;
            }
            return false;
        }

        @Override
        public void restore() {
        }

        @Override
        public void restore(Action<T> action) {
            this.executables.restore(action);
        }

        @Override
        public Scheduler scheduler() {
            return this.scheduler;
        }

        @Override
        public void startTimer(long timeout) {
            if (timeout > 0L && this.scheduler != null && this.cancellable == null) {
                this.cancellable = this.scheduler.scheduleOnce(this, null, 2L, timeout);
            }
        }

        @Override
        public void intervalSignal(Scheduled<Object> scheduled, Object data) {
            if (!this.isOutcomeKnown() && !this.executables.isReadyToExecute()) {
                this.timedOut.set(true);
                this.failed();
            }
        }

        public String toString() {
            return "BasicActiveState[id= " + this.id + "actions=" + this.executables.count() + "]";
        }
    }

    private static class Executables<T> {
        private AtomicBoolean accessible = new AtomicBoolean(false);
        private Queue<Action<T>> actions = new ConcurrentLinkedQueue<Action<T>>();
        private AtomicBoolean readyToExecute = new AtomicBoolean(false);
        private AtomicBoolean wasExecutable = new AtomicBoolean(false);

        Executables() {
        }

        int count() {
            return this.actions.size();
        }

        void execute(ActiveState<T> state) {
            while (!this.accessible.compareAndSet(false, true)) {
            }
            this.readyToExecute.set(true);
            this.wasExecutable.set(true);
            this.executeActions(state);
            this.accessible.set(false);
        }

        boolean isReadyToExecute() {
            return this.readyToExecute.get();
        }

        void registerWithExecution(Action<T> action, long timeout, ActiveState<T> state) {
            while (!this.accessible.compareAndSet(false, true)) {
            }
            this.actions.add(action);
            if (this.isReadyToExecute()) {
                this.executeActions(state);
            } else {
                state.startTimer(timeout);
            }
            this.accessible.set(false);
        }

        void reset() {
            this.readyToExecute.set(false);
            this.actions.clear();
        }

        void restore(Action<T> action) {
            this.actions.add(action);
        }

        private boolean hasAction() {
            return !this.actions.isEmpty();
        }

        private void executeActions(ActiveState<T> state) {
            while (this.hasAction()) {
                if (state.hasOutcome() && state.hasFailed()) {
                    state.executeFailureAction();
                    return;
                }
                if (state.hasException()) {
                    state.handleException();
                    return;
                }
                Action action = this.actions.poll();
                state.backUp(action);
                if (action.hasDefaultValue && state.outcomeMustDefault()) {
                    state.outcome(action.defaultValue);
                    continue;
                }
                try {
                    if (action.isConsumer()) {
                        action.asConsumer().accept(state.outcome());
                        continue;
                    }
                    if (!action.isFunction()) continue;
                    if (action.hasNestedCompletes()) {
                        ((Completes)action.asFunction().apply(state.outcome())).andThenConsume(value -> action.nestedCompletes().with(value));
                        continue;
                    }
                    state.outcome(action.asFunction().apply(state.outcome()));
                }
                catch (Exception e) {
                    state.handleException(e);
                    break;
                }
            }
        }

        boolean wasExecutable() {
            return this.wasExecutable.get();
        }
    }

    protected static interface ActiveState<T> {
        public void await();

        public boolean await(long var1);

        public void backUp(Action<T> var1);

        public void cancelTimer();

        public ActiveState<T> child();

        public void child(ActiveState<T> var1);

        public boolean hasChild();

        public void completedWith(T var1);

        public boolean executeFailureAction();

        public boolean isExecutable();

        public boolean hasFailed();

        public void failed();

        public <F> void failedValue(F var1);

        public T failedValue();

        public void failureAction(Action<T> var1);

        public List<Action<T>> failureActions();

        public void failureActions(List<Action<T>> var1);

        public boolean handleFailure(T var1);

        public void exceptionAction(Function<Exception, T> var1);

        public void handleException();

        public void handleException(Exception var1);

        public boolean hasException();

        public boolean hasOutcome();

        public String id();

        public void outcome(T var1);

        public <O> O outcome();

        public boolean isOutcomeKnown();

        public void outcomeKnown(boolean var1);

        public boolean outcomeMustDefault();

        public void registerWithExecution(Action<T> var1, long var2, ActiveState<T> var4);

        public boolean isRepeatable();

        public void repeat();

        public <F> boolean replaceFailedOutcomeValue(F var1);

        public void restore();

        public void restore(Action<T> var1);

        public Scheduler scheduler();

        public void startTimer(long var1);
    }

    protected static class Action<T> {
        private final T defaultValue;
        private final boolean hasDefaultValue;
        private final Object function;
        private final Completes<T> nestedCompletes;

        static <T> Action<T> with(Object function) {
            return new Action<T>(function);
        }

        static <T> Action<T> with(Object function, Completes<T> nestedCompletes) {
            return new Action<T>(function, nestedCompletes);
        }

        static <T> Action<T> with(Object function, T defaultValue, Completes<T> nestedCompletes) {
            return new Action<T>(function, defaultValue, nestedCompletes);
        }

        Action(Object function) {
            this.function = function;
            this.defaultValue = null;
            this.hasDefaultValue = false;
            this.nestedCompletes = null;
        }

        Action(Object function, T defaultValue) {
            this.function = function;
            this.defaultValue = defaultValue;
            this.hasDefaultValue = true;
            this.nestedCompletes = null;
        }

        Action(Object function, Completes<T> nestedCompletes) {
            this.function = function;
            this.defaultValue = null;
            this.hasDefaultValue = false;
            this.nestedCompletes = nestedCompletes;
        }

        Action(Object function, T defaultValue, Completes<T> nestedCompletes) {
            this.function = function;
            this.defaultValue = defaultValue;
            this.hasDefaultValue = true;
            this.nestedCompletes = nestedCompletes;
        }

        <F> F function() {
            return (F)this.function;
        }

        Consumer<T> asConsumer() {
            return (Consumer)this.function;
        }

        boolean isConsumer() {
            return this.function instanceof Consumer;
        }

        Function<T, T> asFunction() {
            return (Function)this.function;
        }

        boolean isFunction() {
            return this.function instanceof Function;
        }

        boolean hasNestedCompletes() {
            return this.nestedCompletes != null;
        }

        Completes<T> nestedCompletes() {
            return this.nestedCompletes;
        }
    }
}

