/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common;

import io.vlingo.common.BasicCompletes;
import io.vlingo.common.Failure;
import io.vlingo.common.Outcome;
import io.vlingo.common.RepeatableCompletes;
import io.vlingo.common.Scheduler;
import io.vlingo.common.Success;
import io.vlingo.common.completes.SinkAndSourceBasedCompletes;
import io.vlingo.common.completes.exceptions.FailedOperationException;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Completes<T> {
    public static <T> Completes<T> using(Scheduler scheduler) {
        if (SinkAndSourceBasedCompletes.isToggleActive()) {
            return SinkAndSourceBasedCompletes.withScheduler(scheduler);
        }
        return new BasicCompletes(scheduler);
    }

    public static <T> Completes<T> noTimeout() {
        return new BasicCompletes((Scheduler)null);
    }

    public static <T> Completes<T> withSuccess(T outcome) {
        if (SinkAndSourceBasedCompletes.isToggleActive()) {
            return SinkAndSourceBasedCompletes.withScheduler(new Scheduler()).with(outcome);
        }
        return new BasicCompletes<T>(outcome, true);
    }

    public static <T> Completes<T> withFailure(T outcome) {
        if (SinkAndSourceBasedCompletes.isToggleActive()) {
            SinkAndSourceBasedCompletes completes = SinkAndSourceBasedCompletes.withScheduler(new Scheduler());
            completes.source.emitError(new FailedOperationException(outcome));
            return completes;
        }
        return new BasicCompletes<T>(outcome, false);
    }

    public static <T> Completes<T> withFailure() {
        return Completes.withFailure(null);
    }

    public static <T> Completes<T> repeatableUsing(Scheduler scheduler) {
        if (SinkAndSourceBasedCompletes.isToggleActive()) {
            return SinkAndSourceBasedCompletes.withScheduler(scheduler);
        }
        return new RepeatableCompletes(scheduler);
    }

    public static <T> Completes<T> repeatableWithSuccess(T outcome) {
        if (SinkAndSourceBasedCompletes.isToggleActive()) {
            return SinkAndSourceBasedCompletes.withScheduler(new Scheduler()).with(outcome);
        }
        return new RepeatableCompletes<T>(outcome, true);
    }

    public static <T> Completes<T> repeatableWithFailure(T outcome) {
        if (SinkAndSourceBasedCompletes.isToggleActive()) {
            Completes<T> failure = SinkAndSourceBasedCompletes.withScheduler(new Scheduler()).with(outcome);
            failure.failed();
            return failure;
        }
        return new RepeatableCompletes<T>(outcome, false);
    }

    public static <T> Completes<T> repeatableWithFailure() {
        return Completes.repeatableWithFailure(null);
    }

    public static <E extends Throwable, A> Completes<Outcome<E, A>> invert(Outcome<E, Completes<A>> outcome) {
        return outcome.resolve(e -> Completes.withSuccess(Failure.of(e)), s -> s.andThen(Success::of));
    }

    public <O> Completes<O> andThen(long var1, O var3, Function<T, O> var4);

    public <O> Completes<O> andThen(O var1, Function<T, O> var2);

    public <O> Completes<O> andThen(long var1, Function<T, O> var3);

    public <O> Completes<O> andThen(Function<T, O> var1);

    public Completes<T> andThenConsume(long var1, T var3, Consumer<T> var4);

    public Completes<T> andThenConsume(T var1, Consumer<T> var2);

    public Completes<T> andThenConsume(long var1, Consumer<T> var3);

    public Completes<T> andThenConsume(Consumer<T> var1);

    public <F, O> O andThenTo(long var1, F var3, Function<T, O> var4);

    public <F, O> O andThenTo(F var1, Function<T, O> var2);

    public <O> O andThenTo(long var1, Function<T, O> var3);

    public <O> O andThenTo(Function<T, O> var1);

    public <E> Completes<T> otherwise(Function<E, T> var1);

    public Completes<T> otherwiseConsume(Consumer<T> var1);

    public Completes<T> recoverFrom(Function<Exception, T> var1);

    public <O> Completes<O> andFinally();

    public <O> Completes<O> andFinally(Function<T, O> var1);

    public void andFinallyConsume(Consumer<T> var1);

    public <O> O await();

    public <O> O await(long var1);

    public boolean isCompleted();

    public boolean hasFailed();

    public void failed();

    public void failed(Exception var1);

    public boolean hasOutcome();

    public T outcome();

    public Completes<T> repeat();

    public Completes<T> timeoutWithin(long var1);

    public <F> Completes<T> useFailedOutcomeOf(F var1);

    public <O> Completes<O> with(O var1);
}

