/*
 * Decompiled with CFR 0.152.
 */
package io.vlingo.common;

import io.vlingo.common.Completes;
import io.vlingo.common.Outcome;
import io.vlingo.common.Success;
import io.vlingo.common.Tuple2;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class Failure<CauseT extends Throwable, ValueT>
implements Outcome<CauseT, ValueT> {
    private final CauseT cause;

    private Failure(CauseT cause) {
        this.cause = cause;
    }

    public static <CauseT extends Throwable, ValueT> Outcome<CauseT, ValueT> of(CauseT cause) {
        return new Failure<CauseT, ValueT>(cause);
    }

    @Override
    public <NextSuccessT> Outcome<CauseT, NextSuccessT> andThen(Function<ValueT, NextSuccessT> action) {
        return this;
    }

    @Override
    public <NextFailure extends Throwable, NextSuccessT> Outcome<NextFailure, NextSuccessT> andThenTo(Function<ValueT, Outcome<NextFailure, NextSuccessT>> action) {
        return this;
    }

    @Override
    public void atLeastConsume(Consumer<ValueT> consumer) {
    }

    @Override
    public Outcome<CauseT, ValueT> otherwise(Function<CauseT, ValueT> action) {
        return Success.of(action.apply(this.cause));
    }

    @Override
    public <NextFailure extends Throwable, NextSuccessT> Outcome<NextFailure, NextSuccessT> otherwiseTo(Function<CauseT, Outcome<NextFailure, NextSuccessT>> action) {
        return action.apply(this.cause);
    }

    @Override
    public ValueT get() throws CauseT {
        throw this.cause;
    }

    @Override
    public ValueT getOrNull() {
        return null;
    }

    public CauseT cause() {
        return this.cause;
    }

    @Override
    public <NextSuccessT> NextSuccessT resolve(Function<CauseT, NextSuccessT> onFailedOutcome, Function<ValueT, NextSuccessT> onSuccessfulOutcome) {
        return onFailedOutcome.apply(this.cause);
    }

    @Override
    public Optional<ValueT> asOptional() {
        return Optional.empty();
    }

    @Override
    public Completes<ValueT> asCompletes() {
        return Completes.withFailure();
    }

    @Override
    public Outcome<NoSuchElementException, ValueT> filter(Function<ValueT, Boolean> filterFunction) {
        return Failure.of((NoSuchElementException)new NoSuchElementException().initCause((Throwable)this.cause));
    }

    @Override
    public <SecondSuccessT> Outcome<CauseT, Tuple2<ValueT, SecondSuccessT>> alongWith(Outcome<?, SecondSuccessT> outcome) {
        return this;
    }

    @Override
    public <NextFailureT extends Throwable> Outcome<NextFailureT, ValueT> otherwiseFail(Function<CauseT, NextFailureT> action) {
        return Failure.of((Throwable)action.apply(this.cause));
    }

    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        return this.cause.equals(((Failure)other).cause);
    }

    public int hashCode() {
        return 31 * this.cause.hashCode();
    }
}

